#!/usr/bin/python -tti
#
# 

from pyfact   import RawData
import sys
from ROOT import TFile, TCanvas, TH2F, TTree, TStyle, TObject
import numpy as np

data_filename = '/media/DomsStick/20120223_205.fits.gz'
calib_filename = '/media/DomsStick/20120223_206.drs.fits.gz'

run = RawData(data_filename, calib_filename, use_CalFactFits = False, do_calibration = False)
offset = run.blm / (2000./4096.)
offset = offset.astype(int)
roi = run.nroi
npix = run.npix

rootfile = TFile('test.root', "RECREATE")
h = TH2F('h', 'diffs', npix, -0.5, npix-0.5, 2401, -1200.5, 1200.5)

for event in run:
    index = event['event_id'].value
    print index, '/', run.nevents
    data = event['data']
    
    cal_data = data.copy()
    
    for pixel in range(npix):
        sc = event['start_cells'][pixel]
        cal_data[pixel,:] -= offset[pixel,sc:sc+roi]
        for d in np.diff(cal_data[pixel,:]):
            h.Fill(pixel, d)

h.Write()
rootfile.Close()
