#!/usr/bin/python -tti
#
# 

from pyfact   import RawData
import sys
from ROOT import TFile, TCanvas, TH2F, TTree, TStyle, TObject
import numpy as np

data_filename = '/fact/raw/2012/06/06/20120606_116.fits.gz'
calib_filename = '/fact/raw/2012/06/06/20120606_112.drs.fits.gz'

run = RawData(data_filename, calib_filename, use_CalFactFits = False, do_calibration = False)
npix = run.npix

rootfile = TFile('20120606_116_diff_wo_offset_sub.root', "RECREATE")
h = TH2F('h', 'diffs', npix, -0.5, npix-0.5, 4801, -2400.5, 2400.5)

for event in run:
    index = event['event_id'].value
    print index, '/', run.nevents
    cal_data = event['data']
    
    
    for pixel in range(npix):
        for d in np.diff(cal_data[pixel,:]):
            h.Fill(pixel, d)

h.Write()
rootfile.Close()
