#!/usr/bin/python -tti
#
# 

from pyfact   import RawData
import sys
from ROOT import TFile, TCanvas, TH2F, TTree, TStyle, TObject
import numpy as np

data_filename = '/fact/raw/2012/06/06/20120606_116.fits.gz'
calib_filename = '/fact/raw/2012/06/06/20120606_112.drs.fits.gz'



run = RawData(data_filename, calib_filename, use_CalFactFits = False, do_calibration = False)
offset = run.blm / (2000./4096.)
offset = offset.astype(int)
roi = run.nroi
npix = run.npix

rootfile = TFile('test.root', "RECREATE")
h = TH2F('h', 'diffs', npix, -0.5, npix-0.5, 2401, -1200.5, 1200.5)

bits = np.zeros( roi-1 )

for event in run:
    index = event['event_id'].value
    print index, '/', run.nevents
    data = event['data']
    
    
    
    for pixel in range(npix):
        sc = event['start_cells'][pixel]
        data[pixel,:] -= offset[pixel,sc:sc+roi]
        
        diffs = np.diff(data[pixel,:])
        
        for i,d in enumerate(diffs):
            if d >= -8 and d <= 7:
                bits[i] = 4
            elif d >= -16 and d <= 15:
                bits[i] = 5
            elif d >= -32 and d <= 31:
                bits[i] = 6
            elif d >= -64 and d <= 63:
                bits[i] = 7
            elif d >= -128 and d <= 127:
                bits[i] = 8
            elif d >= -256 and d <= 255:
                bits[i] = 9
            elif d >= -512 and d <= 511:
                bits[i] = 10
            else:
                bits[i] = 16
        
        groups = np.array_split(bits,np.where( np.diff(a)!=0 )[0]+1)
        
        cost = 2
        for group in groups:
            cost += 2
            cost += group.sum() / 8
            if group.sum() % 8 != 0:
                cost += 1
        
        sys.exit(0)
        
        for d in diffs:
            h.Fill(pixel, d)

h.Write()
rootfile.Close()
