
// reading a complete binary file
#include <iostream>
#include <fstream>
#include <vector>
using namespace std;

ifstream::pos_type size;
char * memblock;

int main () {
    
    ifstream file ("a.fits", ios::in|ios::binary);
    ofstream out ("bla.bin", ios::out|ios::binary|ios::trunc);
    
    if (file.is_open() && out.is_open())
    {
        // create our own header
        //out.write( "FACT_COMPRESS                                                                   ", 80);
        //out.write( "END.                                                                            ", 80);
        
        // copy first 0x2d00 bytes to new file
        const int ascii_header_size = 0x2d00;
        char * memblock = new char [ascii_header_size];
        file.read(memblock, ascii_header_size);
        out.write(memblock, ascii_header_size);
        delete[] memblock;
        
        for ( int event_id = 0 ; event_id < 1000; event_id++)
        //while ( file.good() )
        {
            // copy binary header to new file
            const int bin_header_size = 3390;
            char * memblock = new char [bin_header_size];
            file.read(memblock, bin_header_size);
            out.write(memblock, bin_header_size);
            delete[] memblock;
            
            // read 300 shorts out of the file
            for (int chid = 0 ; chid < 1440; chid++)
            {
                const int data_size = 300;
                const int diff_size = data_size;
                char * memblock = new char [data_size*sizeof(short)];
                short * data = (short *)memblock;
                short * diffs = new short [diff_size];
                unsigned char * sizes = new unsigned char [diff_size];
                
                file.read(memblock, data_size*sizeof(short) );
                
                for ( int i = 0; i<diff_size; i++)
                {
                    diffs[i] = data[i]-data[i];
                    //~ if (diffs[i] >= -32 && diffs[i] <= 31)
                        //~ sizes[i] = 6;
                    //~ else if (diffs[i] >= -128 && diffs[i] <= 127)
                        //~ sizes[i] = 8;
                    //~ else if (diffs[i] >= -512 && diffs[i] <= 511)
                        //~ sizes[i] = 10;
                    //~ else
                        //~ sizes[i] = 16;
                    if (diffs[i] >= -128 && diffs[i] <= 127)
                        sizes[i] = 8;
                    else
                        sizes[i] = 16;
                }
                
                // calculate group sizes
                int counter = 0;
                unsigned char last_size = sizes[0];
                vector<int> group_sizes;
                vector<unsigned char> groups;
                
                for (int i=0 ; i < diff_size; i++)
                {
                    
                    if (sizes[i] != last_size)
                    {
                        group_sizes.push_back( counter );
                        groups.push_back( last_size );
                        last_size = sizes[i];
                    }
                    counter++;
                }
                groups.push_back( last_size );
                group_sizes.push_back( counter );
                
                
                // write the first short
                out.write(memblock, 1*sizeof(short) );
                // for all groups write header and group
                short header = 0;
                int diff_index = 0;
                for ( int i = 0 ; i < (int)groups.size() ; i++)
                {
                    // write header
                    if (groups[i] == 8)
                    {
                        header = short(group_sizes[i]);
                    }
                    else
                    {
                        header = 0x8000 | short(group_sizes[i] );
                    }
                    out.write( (char*)&header, sizeof(short));
                    
                    // write group
                    if (groups[i] == 8)
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 1);
                        }
                    }
                    else
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 1);
                        }
                        
                    }
                }
                
                //out.write(memblock, data_size*sizeof(short) );
                
                delete[] memblock;
                delete[] diffs;
                delete[] sizes;
            }
        }
        cout << "finished with 1000 events." << endl;
        long after_address = file.tellg();
        file.seekg (0, ios::end);
        long end = file.tellg();
        file.seekg (after_address, ios::beg);
        
        cout << "between last event and end:" << end - after_address << endl;
        // read the last piece...
        const int rest_size = end-after_address;
        char * memblock2 = new char [rest_size];
        file.read(memblock2, rest_size);
        cout << "first char in memblock: " << int(memblock2[0]) << endl;
        char lastchar = memblock2[0];
        for (int i =0 ; i<rest_size; i++)
        {
            if (memblock2[i] != lastchar)
            {
                cout << "new char at: " << i << " with value:" << int(memblock[0]) << endl;
                lastchar = memblock2[i];
            }
        }
        
        out.write(memblock2, rest_size);
        delete[] memblock2;
        
        
        file.close();
        out.close();
  } //end of if file open
} //end of main