#include <iostream>
#include <fstream>
#include <vector>
#include <string.h>

// I will use the fits class by TB for reading the interesting data from the files

#include "izstream.h"

#define HAVE_ZLIB
#include "fits.h"

#include "helper.hxx"

using namespace std;

ifstream::pos_type size;
char * memblock;

int main (int argc, char * argv[]) {

    char * data_file_name = "20120712_004.fits";
    char * calib_file_name ="20120712_003.drs.fits.gz";
    char * out_file_name = NULL;
    out_file_name = new char[strlen(data_file_name)+4];
    strcpy(out_file_name, data_file_name);
    strcpy(out_file_name+strlen(data_file_name),".fc");
    out_file_name[strlen(data_file_name)+3] = 0;

    
    //=========================================================================
    // CALIBRATION CONSTANTS
    //=========================================================================
    fits * calib =new fits(calib_file_name);
    calib->PrintKeys();
    calib->PrintColumns();

    int size_of_offset = 1440*1024;
    float * offset_mV = new float[size_of_offset];
    short * offset = new short[size_of_offset];
    calib->SetPtrAddress("BaselineMean",offset_mV, size_of_offset);

    calib->GetNextRow();
    for (int i =0 ; i<size_of_offset; i++)
    {
        offset[i] = short(offset_mV[i] / 2000. * 4096 - 0.5);
    }
    cout << endl;
    delete[] offset_mV;
    delete calib;
    calib = NULL;
    //=========================================================================
    // END OF                CALIBRATION CONSTANTS
    //=========================================================================
    
    
    //=========================================================================
    // DATA FILE - with FITS class
    //=========================================================================
    
    fits * datafits = new fits(data_file_name);
    
    datafits->PrintKeys();
    datafits->PrintColumns();
    
    int nevents = (int)datafits->GetNumRows();
    int roi = (int)datafits->GetInt("NROI");
    int npixel = (int)datafits->GetInt("NPIX");
    int event_size = npixel * roi;


    
    short *event = new short[event_size];
    short *sc = new short[npixel];
    datafits->SetPtrAddress("Data",event, event_size );
    datafits->SetPtrAddress("StartCellData",sc, npixel );
    
    short first_word;
    short *diffs = new short[event_size-1];
    short *sizes = new short[event_size-1];
    
    //=========================================================================
    // DATA FILE - with ISTREAM
    //=========================================================================
    ifstream datafile (data_file_name, ios::in|ios::binary);
    ofstream out (out_file_name, ios::out|ios::binary|ios::trunc);
    helper h(&datafile, &out);
    
    
    if (datafile.is_open() && out.is_open())
    {
        // create our own header
//        out.write( "FACT_COMPRESS                                                                   ", 80);
//        out.write( "END.                                                                            ", 80);
        
        h.copy_ascii_header();
        
        for ( int event_id = 0 ; event_id < nevents; event_id++)
        {
            h.copy_event_header();
            printf("last event header @: 0x%10X \n", h.event_header_start);


            // jump over npixel * roi * shorts
            datafile.seekg( datafile.tellg() + long(npixel * roi * sizeof(short)) , ios::beg);
            // since the data is stored big-endian in the FITS file, I can't memcopy it .. 
            // have to use the methods of the fits-class
            
            datafits->GetNextRow();
            
            // perform a little DRS calibration
            for ( int pix=0; pix<npixel; pix++){
                short *pevt = event+pix*roi;
                short cell = sc[pix];
                short *poff = offset+pix*1024;
                
                for ( int sl=0 ; sl<roi; sl++)
                {
                    pevt[sl] -= poff[(sl+cell)%1024];
                }                
            
            }
            
            
            first_word = event[0];
            for (int i=0; i<event_size-1; i++)    
            {
                diffs[i] = event[i+1]-event[i];
                if (diffs[i] >= -8 && diffs[i] <= 7)
                    sizes[i] = 4; 
                else if (diffs[i] >= -16 && diffs[i] <= 15)
                    sizes[i] = 5;
                else if (diffs[i] >= -32 && diffs[i] <= 31)
                    sizes[i] = 6; 
                else if (diffs[i] >= -128 && diffs[i] <= 127)
                    sizes[i] = 8;
                else if (diffs[i] >= -256 && diffs[i] <=255)
                    sizes[i] = 9;
                else if (diffs[i] >= -512 && diffs[i] <= 511)
                    sizes[i] = 10;
                else if (diffs[i] >= -1024 && diffs[i] <= 1023)
                    sizes[i] = 11;
                else if (diffs[i] >= -2048 && diffs[i] <= 2047)
                    sizes[i] = 12;
                else
                    sizes[i] = 16;
                /*      
                if (diffs[i] >= -128 && diffs[i] <= 127)
                    sizes[i] = 8;
                else
                    sizes[i] = 16;
                */
            }

            

            short last_size = 77;            
            long long cevts = sizeof(first_word)*8;
            vector< vector<int> > groups;
            for (int i=0; i<event_size-1; i++)
            {
                if (last_size != sizes[i])
                {
                    vector<int> dummy;
                    groups.push_back( dummy );
                    last_size = sizes[i];
                }
                groups.back().push_back(i);
            }
            
            // calc compressed event size
            cevts = sizeof(first_word)*8;
            for (int i=0; i<groups.size(); i++)
            {
                cevts += 16; // so called group header 2 bytes long                
                cevts += groups[i].size() * sizes[groups[i][0]];
            }
            cout << double(cevts)/8.<< endl;
            cout << "\t number of groups:" << groups.size() << endl;
                      
  
            cout << "optimizing..." << endl;
            int was_better = 1;
            long long last_cevts = cevts;
            while ( was_better )
            {
        
               for (int i=0; i<groups.size(); i++)
               {
                   if ((groups[i].size() == 1) && (sizes[groups[i][0]] < sizes[groups[i+1][0]]) )
                   {
                       // put the group into the right neighbor
                       // increase the sizes of this group
                       for(int j=0; j<groups[i].size(); j++)
                       {
                           sizes[groups[i][j]] = sizes[groups[i+1][0]];
                       }
                       // put the groups togther
                       groups[i].insert(groups[i].end(), groups[i+1].begin(), groups[i+1].end());
                       // erase the right group
                       groups.erase(groups.begin()+i+1);
                       break;   
                   }
               }

               cevts = sizeof(first_word)*8;
               for (int i=0; i<groups.size(); i++)
               {
                   cevts += 16; // so called group header 2 bytes long                
                   cevts += groups[i].size() * sizes[groups[i][0]];
               }
//               cout << double(cevts)/8.<< endl;
            
            if (cevts < last_cevts)
                was_better = 1;
             else
                was_better = 0;
            last_cevts =  cevts;
            }           
            
            cout << double(cevts)/8.<< endl;
            cout << "\t number of groups:" << groups.size() << endl;
            
            cout << "optimizing..." << endl;
            was_better = 1;
            last_cevts = cevts;
            while ( was_better )
            {
        
               for (int i=0; i<groups.size(); i++)
               {
                   if ((groups[i].size() == 2) && (sizes[groups[i][0]] < sizes[groups[i+1][0]]) )
                   {
                       // put the group into the right neighbor
                       // increase the sizes of this group
                       for(int j=0; j<groups[i].size(); j++)
                       {
                           sizes[groups[i][j]] = sizes[groups[i+1][0]];
                       }
                       // put the groups togther
                       groups[i].insert(groups[i].end(), groups[i+1].begin(), groups[i+1].end());
                       // erase the right group
                       groups.erase(groups.begin()+i+1);
                       break;   
                   }
               }

               cevts = sizeof(first_word)*8;
               for (int i=0; i<groups.size(); i++)
               {
                   cevts += 16; // so called group header 2 bytes long                
                   cevts += groups[i].size() * sizes[groups[i][0]];
               }
//               cout << double(cevts)/8.<< endl;
            
            if (cevts < last_cevts)
                was_better = 1;
             else
                was_better = 0;
            last_cevts =  cevts;
            }           
            
            cout << double(cevts)/8.<< endl;
            cout << "\t number of groups:" << groups.size() << endl;
            
            cout << "optimizing..." << endl;
            was_better = 1;
            last_cevts = cevts;
            while ( was_better )
            {
        
               for (int i=0; i<groups.size(); i++)
               {
                   if ((groups[i].size() == 3) && (sizes[groups[i][0]] < sizes[groups[i+1][0]]) )
                   {
                       // put the group into the right neighbor
                       // increase the sizes of this group
                       for(int j=0; j<groups[i].size(); j++)
                       {
                           sizes[groups[i][j]] = sizes[groups[i+1][0]];
                       }
                       // put the groups togther
                       groups[i].insert(groups[i].end(), groups[i+1].begin(), groups[i+1].end());
                       // erase the right group
                       groups.erase(groups.begin()+i+1);
                       break;   
                   }
               }

               cevts = sizeof(first_word)*8;
               for (int i=0; i<groups.size(); i++)
               {
                   cevts += 16; // so called group header 2 bytes long                
                   cevts += groups[i].size() * sizes[groups[i][0]];
               }
//               cout << double(cevts)/8.<< endl;
            
            if (cevts < last_cevts)
                was_better = 1;
             else
                was_better = 0;
            last_cevts =  cevts;
            }           
            
            cout << double(cevts)/8.<< endl;
            cout << "\t number of groups:" << groups.size() << endl;
            
            int min = 100;
            int argmin;
            int minsize;
            for (int i=0; i<groups.size(); i++)
            {
                if (groups[i].size() < min)
                {
                    min = groups[i].size();
                    argmin = i;
                    minsize = sizes[groups[i][0]];
                }
            }
            cout << "min:" << min << endl;
            cout << "argmin:" << argmin << endl;
            cout << "minsize:" << minsize << endl;
            
            
            return 0;
/*                
                // calculate group sizes
                int counter = 0;
                unsigned char last_size = sizes[0];
                vector<int> group_sizes;
                vector<unsigned char> groups;
                
                for (int i=0 ; i < diff_size; i++)
                {
                    
                    if (sizes[i] != last_size)
                    {
                        group_sizes.push_back( counter );
                        groups.push_back( last_size );
                        last_size = sizes[i];
                    }
                    counter++;
                }
                groups.push_back( last_size );
                group_sizes.push_back( counter );
                

                // measure how large the stuff, is
                int cs =0;
                // for all groups write header and group
                short header = 0;
                int diff_index = 0;
                for ( int i = 0 ; i < (int)groups.size() ; i++)
                {
                    // write header
                    if (groups[i] == 8)
                    {
                        header = short(group_sizes[i]);
                    }
                    else
                    {
                        header = 0x8000 | short(group_sizes[i] );
                    }
                    cs += sizeof(short);

                    // write group
                    if (groups[i] == 8)
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            cs += 1;
                        }
                    }
                    else
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            cs += 2;
                        }
                    }
                }
                //cout << "compressed size:" << cs << endl;
                out.write( (char*)&cs, sizeof(cs));

                cout << "sizeof(cs):" << sizeof(cs) << endl;

                // write the first short
                out.write(memblock, 1*sizeof(short) );
                printf("first short: 0x%X \t %d \n", ( (short*)memblock )[0], ( (short*)memblock )[0] );
                // for all groups write header and group
                header = 0;
                diff_index = 0;
                for ( int i = 0 ; i < (int)groups.size() ; i++)
                {
                    // write header
                    if (groups[i] == 8)
                    {
                        header = short(group_sizes[i]);
                    }
                    else
                    {
                        header = 0x8000 | short(group_sizes[i] );
                    }
                    out.write( (char*)&header, sizeof(short));
                    
                    // write group
                    if (groups[i] == 8)
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 1);
                        }
                    }
                    else
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 2);
                        }
                    }
                }
                
                //out.write(memblock, data_size*sizeof(short) );
                
                delete[] memblock;
                delete[] diffs;
                delete[] sizes;
*/
            //}
            
        }
        cout << "finished with 1000 events." << endl;
        long after_address = datafile.tellg();
        datafile.seekg (0, ios::end);
        long end = datafile.tellg();
        datafile.seekg (after_address, ios::beg);
        
        cout << "between last event and end:" << end - after_address << endl;
        // read the last piece...
        const int rest_size = end-after_address;
        char * memblock2 = new char [rest_size];
        datafile.read(memblock2, rest_size);
        cout << "first char in memblock: " << int(memblock2[0]) << endl;
        char lastchar = memblock2[0];
        for (int i =0 ; i<rest_size; i++)
        {
            if (memblock2[i] != lastchar)
            {
                cout << "new char at: " << i << " with value:" << int(memblock[0]) << endl;
                lastchar = memblock2[i];
            }
        }
        
        out.write(memblock2, rest_size);
        delete[] memblock2;
        
        
        datafile.close();
        out.close();
  } //end of if file open
} //end of main
