#include <iostream>
#include <fstream>
#include <vector>
#include <string.h>
#include <math.h>

// I will use the fits class by TB for reading the interesting data from the files

#include "izstream.h"

#define HAVE_ZLIB
#include "fits.h"

#include "helper.hxx"

using namespace std;

ifstream::pos_type size;
char * memblock;

void make_groups( vector<int>& group_starts , vector<int>& group_length, short * sizes, int len_sizes, int roi);
long get_event_size( vector<int>& gs, vector<int>& gl, short * sizes);

int main (int argc, char * argv[]) {

    char * data_file_name = "20120712_004.fits";
    char * calib_file_name ="20120712_003.drs.fits.gz";
    char * out_file_name = NULL;
    out_file_name = new char[strlen(data_file_name)+4];
    strcpy(out_file_name, data_file_name);
    strcpy(out_file_name+strlen(data_file_name),".fc");
    out_file_name[strlen(data_file_name)+3] = 0;

    
    //=========================================================================
    // CALIBRATION CONSTANTS
    //=========================================================================
    fits * calib =new fits(calib_file_name);
    calib->PrintKeys();
    calib->PrintColumns();

    int size_of_offset = 1440*1024;
    float * offset_mV = new float[size_of_offset];
    short * offset = new short[size_of_offset];
    calib->SetPtrAddress("BaselineMean",offset_mV, size_of_offset);

    calib->GetNextRow();
    for (int i =0 ; i<size_of_offset; i++)
    {
        offset[i] = short(offset_mV[i] / 2000. * 4096 - 0.5);
    }
    cout << endl;
    delete[] offset_mV;
    delete calib;
    calib = NULL;
    //=========================================================================
    // END OF                CALIBRATION CONSTANTS
    //=========================================================================
    
    
    //=========================================================================
    // DATA FILE - with FITS class
    //=========================================================================
    
    fits * datafits = new fits(data_file_name);
    
    datafits->PrintKeys();
    datafits->PrintColumns();
    
    int nevents = (int)datafits->GetNumRows();
    int roi = (int)datafits->GetInt("NROI");
    int npixel = (int)datafits->GetInt("NPIX");
    int event_size = npixel * roi;


    
    short *event = new short[event_size];
    short *sc = new short[npixel];
    datafits->SetPtrAddress("Data",event, event_size );
    datafits->SetPtrAddress("StartCellData",sc, npixel );
    
    short first_word;
    short *diffs = new short[event_size-1];
    short *sizes = new short[event_size-1];
    
    //=========================================================================
    // DATA FILE - with ISTREAM
    //=========================================================================
    ifstream datafile (data_file_name, ios::in|ios::binary);
    ofstream out (out_file_name, ios::out|ios::binary|ios::trunc);
    helper h(&datafile, &out);
    
    
    if (datafile.is_open() && out.is_open())
    {
        // create our own header
//        out.write( "FACT_COMPRESS                                                                   ", 80);
//        out.write( "END.                                                                            ", 80);
        
//        h.copy_ascii_header();
        
        for ( int event_id = 0 ; event_id < nevents; event_id++)
        {
//            h.copy_event_header();
            printf("last event header @: 0x%10X \n", h.event_header_start);


            // jump over npixel * roi * shorts
            datafile.seekg( datafile.tellg() + long(npixel * roi * sizeof(short)) , ios::beg);
            // since the data is stored big-endian in the FITS file, I can't memcopy it .. 
            // have to use the methods of the fits-class

            datafits->GetNextRow();

            // perform a little DRS calibration
            for ( int pix=0; pix<npixel; pix++){
                short *pevt = event+pix*roi;
                short cell = sc[pix];
                short *poff = offset+pix*1024;
                
                for ( int sl=0 ; sl<roi; sl++)
                {
                    pevt[sl] -= poff[(sl+cell)%1024];
                }                
            
            }

            
            first_word = event[0];
            //event_size = 100;
            
            short d;
            for (int i=0; i<event_size-1; i++)    
            {
                diffs[i] = event[i+1]-event[i];
                d = diffs[i];
                for (int b =4; b<20; b++)
                {
                    if ( (d >= -1*(1<<b)) && (d <= (1<<b)-1))
                    {
                        sizes[i] = b+1;
                        break;
                    }
                }
            }

            vector<int> gs;
            vector<int> gl;
            make_groups( gs , gl, sizes, event_size-1, event_size);            

            long cevts = get_event_size( gs,gl, sizes);            

            cout << cevts << endl;
            cout << "number of groups:" << gs.size() << endl;

            // write the length of the event
            out.write( (char*) &cevts, sizeof(cevts) );
            // write the event to disk
            out.write( (char*)&first_word, sizeof(first_word));
            unsigned short header;
            for (int g=0; g<gs.size(); g++){
                
                if (g<50)
    //                printf("group: %3d length: %4d -- size: %2d ", g, gl[g], sizes[gs[g]]);

                header = (unsigned short)gl[g] & 0x0FFF;
                header |= (sizes[gs[g]]-5) << 12;

                out.write( (char*)&header, sizeof(header));
                int group_size = ceil((gl[g]*sizes[gs[g]])/8.);
                if (g<50)
  //                  printf("group_size: %4d ", group_size);
                
                int size = sizes[gs[g]];
                unsigned char * buffer = new unsigned char[ group_size ];
                for (int i=0; i<group_size; i++) buffer[i] = 0;
                unsigned short *data = (unsigned short *)diffs;

                int *bs = new int[gl[g]];
                int *Bs = new int[gl[g]];

                for (int i=0; i<gl[g] ;i++)
                {
                    int bit_pos = ((i+1)*size)-1;
                    Bs[i] = bit_pos/8;
                    bs[i] = bit_pos%8;
                }
                
                for (int i=0; i<gl[g] ;i++)
                {
                    int ii = i+gs[i];
                    unsigned char dat = (unsigned char)(diffs[ii]);
                    if (bs[i]+1 >= size) // diff entry fits in one byte
                    {
                        buffer[Bs[i]] |= dat <<(bs[i]+1-size);
                    }
                    else // entry is distributed over two bytes
                    {
                        buffer[Bs[i]]   |= dat>>(size - bs[i]+1);
                        buffer[Bs[i-1]] |= dat<<(8-size - bs[i]+1);
                    }
                }
                delete[] bs;
                delete[] Bs;
                if (g<50)
                {
                    int tellp = out.tellp();
//                    printf("start_addres: 0x%8X\n", tellp);
                }

                
                out.write( (char*)buffer, group_size);
                delete[] buffer;
            
            }



            return 0;
/*                
                

                // measure how large the stuff, is
                int cs =0;
                // for all groups write header and group
                short header = 0;
                int diff_index = 0;
                for ( int i = 0 ; i < (int)groups.size() ; i++)
                {
                    // write header
                    if (groups[i] == 8)
                    {
                        header = short(group_sizes[i]);
                    }
                    else
                    {
                        header = 0x8000 | short(group_sizes[i] );
                    }
                    cs += sizeof(short);

                    // write group
                    if (groups[i] == 8)
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            cs += 1;
                        }
                    }
                    else
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            cs += 2;
                        }
                    }
                }
                //cout << "compressed size:" << cs << endl;
                out.write( (char*)&cs, sizeof(cs));

                cout << "sizeof(cs):" << sizeof(cs) << endl;

                // write the first short
                out.write(memblock, 1*sizeof(short) );
                printf("first short: 0x%X \t %d \n", ( (short*)memblock )[0], ( (short*)memblock )[0] );
                // for all groups write header and group
                header = 0;
                diff_index = 0;
                for ( int i = 0 ; i < (int)groups.size() ; i++)
                {
                    // write header
                    if (groups[i] == 8)
                    {
                        header = short(group_sizes[i]);
                    }
                    else
                    {
                        header = 0x8000 | short(group_sizes[i] );
                    }
                    out.write( (char*)&header, sizeof(short));
                    
                    // write group
                    if (groups[i] == 8)
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 1);
                        }
                    }
                    else
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 2);
                        }
                    }
                }
                
                //out.write(memblock, data_size*sizeof(short) );
                
                delete[] memblock;
                delete[] diffs;
                delete[] sizes;
*/
            //}
            
        }
        cout << "finished with 1000 events." << endl;
        long after_address = datafile.tellg();
        datafile.seekg (0, ios::end);
        long end = datafile.tellg();
        datafile.seekg (after_address, ios::beg);
        
        cout << "between last event and end:" << end - after_address << endl;
        // read the last piece...
        const int rest_size = end-after_address;
        char * memblock2 = new char [rest_size];
        datafile.read(memblock2, rest_size);
        cout << "first char in memblock: " << int(memblock2[0]) << endl;
        char lastchar = memblock2[0];
        for (int i =0 ; i<rest_size; i++)
        {
            if (memblock2[i] != lastchar)
            {
                cout << "new char at: " << i << " with value:" << int(memblock[0]) << endl;
                lastchar = memblock2[i];
            }
        }
        
        out.write(memblock2, rest_size);
        delete[] memblock2;
        
        
        datafile.close();
        out.close();
  } //end of if file open
} //end of main

void make_groups( vector<int>& group_starts , vector<int>& group_length, short * sizes, int len_sizes, int roi)
{

    short * diff_sizes = new short[len_sizes-1];

    for (int i=0; i<len_sizes-1; i++)
    {
        diff_sizes[i] = sizes[i+1] - sizes[i];
    }

    vector<int> gs;
    vector<int> gl;


    gs.push_back(0);
    for (int i=0; i<len_sizes-1; i++)
    {
        if (diff_sizes[i] != 0) 
        {
            gs.push_back(i+1);
        }
    }
    gs.push_back(roi-1);

    // make group_length the same length as group_start
    gl.reserve( gs.size()-1 );
    for (int i=0; i<gs.size()-1; i++)
    {
        gl[i] = gs[i+1] - gs[i];
    }

    gs.erase(gs.begin()+gs.size()-1);

    group_starts.swap(gs);
    group_length.swap(gl);
}

long get_event_size( vector<int>& gs, vector<int>& gl, short * sizes)
{
    long bits;
    // eventsize in bytes
    long evts = 2; // the first word
    
    // gs and gl have equal length
    for (int i=0; i<gs.size(); i++)
    {
        evts += 2; // group header
        bits = sizes[gs[i]] * gl[i];
        evts += ceil( bits/8.);
        
    }
    return evts;            
}
