#include <iostream>
#include <fstream>
#include <math.h>
using namespace std;



int main (int argc, char *argv[]) {
unsigned char symbol;
unsigned long *multiples = NULL;
double *probs = NULL;
double entropy = 0;
ofstream outfile;
ifstream in1;
long begin,end, size;
    
    int bits = sizeof(symbol)*8;
    long symbols = 1<<bits;
    multiples = new unsigned long [symbols];
    probs = new double [symbols];

    if (argc > 1)
    {
        in1.open(argv[1], ios::in|ios::binary);
    }
    else
    {
        return 1;
    }
    
    outfile.open("entropy.txt");

    if (in1.is_open())
    {                  
        begin = in1.tellg();
        in1.seekg (0, ios::end);
        end = in1.tellg();
        in1.seekg (0, ios::beg);
        size = end-begin;
        outfile << argv[1] << "  size:" << size << endl;
        outfile << "symbols:" << symbols << endl;

        while ( in1.good())
        {
            symbol = in1.get();
            multiples[symbol]++;
        }

        outfile << "multiples:" << endl;
        for (long i=0; i<symbols; i++)
        {
            outfile << multiples[i] << "\t";
            probs[i] = double(multiples[i])/size;
        }
        outfile << endl;

        outfile << "probs:" << endl;
        for (long i=0; i<symbols; i++)
        {
            outfile << probs[i] << "\t";
            if (probs[i] > 0.)
            {
                entropy += probs[i] * log(probs[i]);
            }
        }
        entropy /= log(2);
        outfile << endl;

        outfile << "entropy:" << entropy << endl;

        
        

        outfile.close();
        in1.close();
  } //end of if file open
  
return 0;
} //end of main
