#include <iostream>
#include <fstream>
#include <vector>
#include <string.h>

// I will use the fits class by TB for reading the interesting data from the files

#include "izstream.h"

#define HAVE_ZLIB
#include "fits.h"

using namespace std;

ifstream::pos_type size;
char * memblock;

int main (int argc, char * argv[]) {


    if (argc < 3)
    {
        cout << "Usage: " << argv[0] << " data-file-name calib-file-name [ouput-file-name]" << endl;
        cout << "" << endl;
    }
    
    char * data_file_name = argv[1];
    char * calib_file_name = argv[2];
    char * out_file_name = 0;
    if (argc == 4)
    {
        out_file_name = argv[3];
    }
    else
    {
        out_file_name = new char[strlen(data_file_name)+4];
        strcpy(out_file_name, data_file_name);
        strcpy(out_file_name+strlen(data_file_name),".uc");
        out_file_name[strlen(data_file_name)+3] = 0;
    }
    
    
    
    
    //=========================================================================
    // CALIBRATION CONSTANTS
    //=========================================================================
    fits * calib =new fits(calib_file_name);
    calib->PrintKeys();
    calib->PrintColumns();

    int size_of_offset = 1440*1024;
    float * offset_mV = new float[size_of_offset];
    short * offset = new short[size_of_offset];
    calib->SetPtrAddress("BaselineMean",offset_mV, size_of_offset);

    calib->GetNextRow();
    for (int i =0 ; i<size_of_offset; i++)
    {
        offset[i] = short(offset_mV[i] / 2000. * 4096 - 0.5);
    }
    cout << endl;
    delete[] offset_mV;
    delete calib;
    calib = NULL;
    //=========================================================================
    // END OF                CALIBRATION CONSTANTS
    //=========================================================================
    
    
    ifstream datafile (data_file_name, ios::in|ios::binary);
    ofstream out (out_file_name, ios::out|ios::binary|ios::trunc);
    if (datafile.is_open() && out.is_open())
    {
        // copy first 0x2d00 bytes to new file
        const int ascii_header_size = 0x2d00;
        char * memblock = new char [ascii_header_size];
        datafile.read(memblock, ascii_header_size);
        out.write(memblock, ascii_header_size);
        delete[] memblock;
        
        for ( int event_id = 0 ; event_id < 1000; event_id++)
        //while ( datafile.good() )
        {
            // copy binary header to new file
            const int bin_header_size = 3390;
            char * memblock = new char [bin_header_size];
            datafile.read(memblock, bin_header_size);
            out.write(memblock, bin_header_size);
            delete[] memblock;
           
            // read the size of the compressed next event
            int cs;
            datafile.read((char*)&cs, sizeof(cs));
            const int data_size = cs;

            // read cs bytes out of the file
            for (int chid = 0 ; chid < 1440; chid++)
            {
                int slices =0;
                short first_short;
                datafile.read((char*)&first_short, sizeof(first_short));
                out.write( (char*)&first_short, sizeof(first_short) );

                while (slices < 300)
                {
                    // read header
                    short header;
                    short group_size;
                    int is_short;
                    datafile.read((char*)&header, sizeof(header));
                    if (header & 0x8000)
                    {
                        // the group data consists of shorts
                        group_size = header | 0x7FFF;
                        short *group;
                        group = new short [group_size];
                        datafile.read( (char*)group, group_size*sizeof(short) );
                        for (int groupsl = 0; groupsl < group_size; groupsl++)
                        {
                            first_short += group[groupsl];
                            out.write( (char*)&first_short, sizeof(short) );
                        }
                        delete[] group;
                    }
                    else
                    {
                        // the group data consists of bytes
                        group_size = header;
                        char *group;
                        group = new char [group_size];
                        datafile.read( (char*)group, group_size*sizeof(char) );
                        for (int groupsl = 0; groupsl < group_size; groupsl++)
                        {
                            first_short += group[groupsl];
                            out.write( (char*)&first_short, sizeof(short) );
                        }
                        delete[] group;
                    }

                    slices += group_size;

                }
            }
        
        
        datafile.close();
        out.close();
  } //end of if file open
} //end of main
