#include <iostream>
#include <fstream>
#include <vector>
#include <string.h>

// I will use the fits class by TB for reading the interesting data from the files

#include "izstream.h"

#define HAVE_ZLIB
#include "fits.h"

using namespace std;

ifstream::pos_type size;
char * memblock;

int main (int argc, char * argv[]) {


    if (argc < 3)
    {
        cout << "Usage: " << argv[0] << " data-file-name calib-file-name [ouput-file-name]" << endl;
        cout << "" << endl;
    }
    
    char * data_file_name = argv[1];
    char * calib_file_name = argv[2];
    char * out_file_name = 0;
    if (argc == 4)
    {
        out_file_name = argv[3];
    }
    else
    {
        out_file_name = new char[strlen(data_file_name)+4];
        strcpy(out_file_name, data_file_name);
        strcpy(out_file_name+strlen(data_file_name),".fc");
        out_file_name[strlen(data_file_name)+3] = 0;
    }
    
    
    
    
    //=========================================================================
    // CALIBRATION CONSTANTS
    //=========================================================================
    fits * calib =new fits(calib_file_name);
    calib->PrintKeys();
    calib->PrintColumns();

    int size_of_offset = 1440*1024;
    float * offset_mV = new float[size_of_offset];
    short * offset = new short[size_of_offset];
    calib->SetPtrAddress("BaselineMean",offset_mV, size_of_offset);

    calib->GetNextRow();
    for (int i =0 ; i<size_of_offset; i++)
    {
        offset[i] = short(offset_mV[i] / 2000. * 4096 - 0.5);
    }
    cout << endl;
    delete[] offset_mV;
    delete calib;
    calib = NULL;
    //=========================================================================
    // END OF                CALIBRATION CONSTANTS
    //=========================================================================
    
    
    ifstream datafile (data_file_name, ios::in|ios::binary);
    ofstream out (out_file_name, ios::out|ios::binary|ios::trunc);
    if (datafile.is_open() && out.is_open())
    {
        // create our own header
        //out.write( "FACT_COMPRESS                                                                   ", 80);
        //out.write( "END.                                                                            ", 80);
        
        // copy first 0x2d00 bytes to new file
        const int ascii_header_size = 0x2d00;
        char * memblock = new char [ascii_header_size];
        datafile.read(memblock, ascii_header_size);
        out.write(memblock, ascii_header_size);
        delete[] memblock;
        
        for ( int event_id = 0 ; event_id < 1000; event_id++)
        //while ( datafile.good() )
        {
            // copy binary header to new file
            const int bin_header_size = 3390;
            char * memblock = new char [bin_header_size];
            datafile.read(memblock, bin_header_size);
            out.write(memblock, bin_header_size);
            delete[] memblock;
            
            // read 300 shorts out of the file
            for (int chid = 0 ; chid < 1440; chid++)
            {
                const int data_size = 300;
                const int diff_size = data_size;
                char * memblock = new char [data_size*sizeof(short)];
                short * data = (short *)memblock;
                short * diffs = new short [diff_size];
                unsigned char * sizes = new unsigned char [diff_size];
                
                datafile.read(memblock, data_size*sizeof(short) );
                
                for ( int i = 0; i<diff_size; i++)
                {
                    diffs[i] = data[i]-data[i];
                    //~ if (diffs[i] >= -32 && diffs[i] <= 31)
                        //~ sizes[i] = 6;
                    //~ else if (diffs[i] >= -128 && diffs[i] <= 127)
                        //~ sizes[i] = 8;
                    //~ else if (diffs[i] >= -512 && diffs[i] <= 511)
                        //~ sizes[i] = 10;
                    //~ else
                        //~ sizes[i] = 16;
                    if (diffs[i] >= -128 && diffs[i] <= 127)
                        sizes[i] = 8;
                    else
                        sizes[i] = 16;
                }
                
                // calculate group sizes
                int counter = 0;
                unsigned char last_size = sizes[0];
                vector<int> group_sizes;
                vector<unsigned char> groups;
                
                for (int i=0 ; i < diff_size; i++)
                {
                    
                    if (sizes[i] != last_size)
                    {
                        group_sizes.push_back( counter );
                        groups.push_back( last_size );
                        last_size = sizes[i];
                    }
                    counter++;
                }
                groups.push_back( last_size );
                group_sizes.push_back( counter );
                
                
                // write the first short
                out.write(memblock, 1*sizeof(short) );
                // for all groups write header and group
                short header = 0;
                int diff_index = 0;
                for ( int i = 0 ; i < (int)groups.size() ; i++)
                {
                    // write header
                    if (groups[i] == 8)
                    {
                        header = short(group_sizes[i]);
                    }
                    else
                    {
                        header = 0x8000 | short(group_sizes[i] );
                    }
                    out.write( (char*)&header, sizeof(short));
                    
                    // write group
                    if (groups[i] == 8)
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 1);
                        }
                    }
                    else
                    {
                        for (int j = 0; j<group_sizes[i]; j++)
                        {
                            out.write( (char*)&(diffs[diff_index++]), 2);
                        }
                    }
                }
                
                //out.write(memblock, data_size*sizeof(short) );
                
                delete[] memblock;
                delete[] diffs;
                delete[] sizes;
            }
        }
        cout << "finished with 1000 events." << endl;
        long after_address = datafile.tellg();
        datafile.seekg (0, ios::end);
        long end = datafile.tellg();
        datafile.seekg (after_address, ios::beg);
        
        cout << "between last event and end:" << end - after_address << endl;
        // read the last piece...
        const int rest_size = end-after_address;
        char * memblock2 = new char [rest_size];
        datafile.read(memblock2, rest_size);
        cout << "first char in memblock: " << int(memblock2[0]) << endl;
        char lastchar = memblock2[0];
        for (int i =0 ; i<rest_size; i++)
        {
            if (memblock2[i] != lastchar)
            {
                cout << "new char at: " << i << " with value:" << int(memblock[0]) << endl;
                lastchar = memblock2[i];
            }
        }
        
        out.write(memblock2, rest_size);
        delete[] memblock2;
        
        
        datafile.close();
        out.close();
  } //end of if file open
} //end of main
