#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <errno.h>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define STATUS_SIZE 1000					// Bytes for status service string

// Declaration of item for history buffer (see DColl.cc)
struct EvidenceHistoryItem {
  int Seconds;
  double Value;
} __attribute__((__packed__));

// Class declation of Evidence server
class EvidenceServer: public DimServer {

  private:
	struct ConfigItem {
	  char *Name;
	  char *Value;
	  int Time;
	} *ConfigList;
	unsigned int ConfigNum;

    char *StatusName;
    DimService *Status;

    static void SignalHandler(int);  // static needed for signal() function
	void errorHandler(int, int, char *);
	void exitHandler(int);
	
  public:
    EvidenceServer(const char *);
	~EvidenceServer();
	
	enum StateType {INFO=0, WARN=1, ERROR=2, FATAL=3};

	void State(StateType, const char *, ...);

	char* GetConfig(const char *);
	static char *ToString(DimInfo *);
	static int MakeString(char **Pointer, const char *Format, ...);
	
    static bool ExitRequest;
};

#endif
