#!/usr/bin/python -tt
# ********************************
# Plot the calibrated events of a file
# 
# written by Thomas Kraehenbuehl, ETH Zurich
# tpk@phys.ethz.ch, +41 44 633 3973
# September 2012
# ********************************

datafile = '/fact/raw/2012/06/08/20120608_009.fits.gz'
calibfile = '/fact/raw/2012/06/08/20120608_007.drs.fits.gz'
pixelnr = 0

import numpy as np
from fileplotter import FilePlotter
import os

datafilename = os.path.basename(datafile)
calibfilename = os.path.basename(calibfile)

from ROOT import gSystem
gSystem.Load("calfactfits_h.so")
from ROOT import *
data = CalFactFits(datafile,calibfile)
npcalevent  = np.empty( data.npix * data.nroi, np.float64) #.reshape(data.npix ,data.nroi)
data.SetNpcaldataPtr(npcalevent)
nroi = data.data_nroi

gROOT.SetStyle("Plain")
#gStyle.SetOptTitle(0)
gStyle.SetOptStat(0)

#Create a canvas with automatic save-function
#Note: most options of Fileplotter (legend, title etc. do not work here)
fp = FilePlotter(out_name="EventDisplay")
fp.canvas()

title = "Data: %s, DRS: %s, Px %i Ev %i"%(datafile,calibfile,pixelnr,0)
pixProfile = TProfile("pix", title, nroi, -0.5, nroi-0.5)
pixProfile.GetXaxis().SetTitle("Slice @ 2 GHz")
pixProfile.GetYaxis().SetTitle("Amplitude (mV)")

print "\nPress"
print "-ENTER to continue"
print "-'a' to abort"
print "-an integer to jump to this event"
print "-'s' to save and continue.\n"

nextEvent = 0

while data.GetCalEvent():
	if nextEvent>data.event_id:
		continue
	
	print data.event_id, hex(data.event_triggertype),
	
	pixProfile.Reset()
	title = "Data: %s, DRS: %s, ContHardID %i Ev %i"%(datafilename,calibfilename,pixelnr,data.event_id)
	pixProfile.SetTitle(title)
	
	for k in range(3,nroi):
		pixProfile.Fill(k,npcalevent[pixelnr*nroi+k]);
	
	pixProfile.Draw()
	fp.canv.Modified()
	fp.canv.Update()
	
	try:
		temp = raw_input()
	except Exception, err:
		print "Caught exception:", err
	except KeyboardInterrupt, err:
		print "Caught keyboard interrupt"
	
	try:
		nextEvent = int(temp)
	except ValueError, err:
		nextEvent = 0
	
	if temp=='s':
		fp.save()
		
	if temp=='a': break

del fp,data
