#!/usr/bin/python -tti
import sys
from pyfact import SlowData
from pylab import *

from datetime import date
d0 = date(1970,01,01)
d1 = date(2001,01,01)
delta = d1-d0
days_offset = delta.days
del d0,d1,delta

plt.ion()

if len(sys.argv) < 3:
    ftm_static = '20120924.FTM_CONTROL_STATIC_DATA.fits'
    ftm_rates = '20120924.FTM_CONTROL_TRIGGER_RATES.fits'
    
else:
    ftm_static = sys.argv[1]
    ftm_rates = sys.argv[2]

f1 = SlowData(ftm_static)
f2 = SlowData(ftm_rates)

f1.register('all')
f2.register('all')
f1.stack()
f2.stack()
print "reading", ftm_static 
for i in f1:
    pass
print "reading", ftm_rates     
for i in f2:
    pass
    
 
c = f1.stacked_cols
t = c['Time']-days_offset

thr = c['PatchThresh']

thrm = thr.mean(axis=1)

scale = 50.
plt.plot_date( t, thrm/scale, '.:', label='Patch THR mean ('+str(scale)+'DAC counts)')

t2 = f2.stacked_cols['Time']-days_offset
log_rates = np.log10(f2.stacked_cols['TriggerRate'])

plt.plot_date( t2, log_rates, '+', label = 'log(Rate/Hz)')
plt.legend()
