/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void MagicHillas(const char *filename="~/data/gamma*.root")
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a Magic root file.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // Uncomment this two line if you want to use MHillasExt instead
    // of MHillas
    //
    //MHillasExt hext;
    //plist.AddToList(&hext);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamMagic geomcam;
    plist.AddToList(&geomcam);

    //
    // Setup binning for your histograms.
    //
    MBinning binswidth("BinningWidth");
    binswidth.SetEdges(100, 0, 1);   // 100 bins from 0 to 1 deg

    MBinning binslength("BinningLength");
    binslength.SetEdges(100, 0, 1);  // 100 bins from 0 to 1 deg

    MBinning binsalpha("BinningAlpha");
    binsalpha.SetEdges(90, 0, 90);   // 90 bins from 0 to 90 deg

    MBinning binsdist("BinningDist");
    binsdist.SetEdges(100, 0, 2);    // 100 bins from 0 to 2 deg

    plist.AddToList(&binswidth);
    plist.AddToList(&binslength);
    plist.AddToList(&binsalpha);
    plist.AddToList(&binsdist);

    //
    // Craete the object which hlods the source positions in the camera
    // plain in respect to which the image parameters will be calculated.
    // For real data the containers will be filled by a task.
    //
    MSrcPosCam source("Source")
    source.SetXY(0, 0);

    MSrcPosCam antisrc("AntiSrc");
    antisrc.SetXY(240, 0);

    plist.AddToList(&source);
    plist.AddToList(&antisrc);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    // The first argument is the tree you want to read.
    //   Events:     Cosmic ray events
    //   PedEvents:  Pedestal Events
    //   CalEvents:  Calibration Events
    //
    MReadMarsFile read("Events", filename);
    read.DisableAutoScheme();

    MMcPedestalCopy   pcopy;
    MMcPedestalNSBAdd pnsb;
    MCerPhotCalc      ncalc;

//  Alternative photon calculation:
//    MCerPhotCalc2     ncalc;
//  Example: use only 2nd to 6th FADC slices for photon calculation:
//    const Float_t x[15]={0., 1., 1., 1., 1., 1., 0.,0.,0.,0.,0.,0.,0.,0.,0.};
//    TArrayF w(15,x);
//    ncalc.SetWeights(w);

    MImgCleanStd      clean;
    MBlindPixelCalc   blind;
    MHillasCalc       hcalc;
    MHillasSrcCalc    csrc1("Source",  "HillasSource");
    MHillasSrcCalc    csrc2("AntiSrc", "HillasAntiSrc");

    MFillH hfill("MHHillas",   "MHillas");
    MFillH sfill("MHStarMap",  "MHillas");
    MFillH hfill2s("HistSource  [MHHillasSrc]", "HillasSource");
    MFillH hfill2a("HistAntiSrc [MHHillasSrc]", "HillasAntiSrc");

    /*
     MWriteRootFile write("hillas.root");
     write.AddContainer("MHillas",       "Hillas");
     write.AddContainer("HillasSource",  "Hillas");
     write.AddContainer("HillasAntiSrc", "Hillas");
     write.AddContainer("MMcEvt",        "Hillas");
     write.AddContainer("MHStarMap");

     MWriteAsciiFile write("hillas.txt");
     write.AddColumn("MHillas.fLength*MGeomCam.fConvMm2Deg");
     write.AddColumn("MHillas", "fConc");
     write.AddColumns("MHillas");
     */

    tlist.AddToList(&read);
    tlist.AddToList(&pcopy);
    tlist.AddToList(&pnsb);
    tlist.AddToList(&ncalc);
    tlist.AddToList(&clean);
    tlist.AddToList(&blind);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&csrc1);
    tlist.AddToList(&csrc2);
    tlist.AddToList(&hfill);
    tlist.AddToList(&sfill);
    tlist.AddToList(&hfill2s);
    tlist.AddToList(&hfill2a);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    //
    // After the analysis is finished we can display the histograms

    plist.FindObject("MHHillas")->DrawClone();
    plist.FindObject("HistSource")->DrawClone();
    plist.FindObject("HistAntiSrc")->DrawClone();
    plist.FindObject("MHStarMap")->DrawClone();
}
