#!/usr/bin/python -tti

##############################################
# based on plot_trigger_rate.py by QW and TPK
##############################################

from array import array
import os
import re
import sys
import numpy as np
import time

from pyfact import SlowData

#from ROOT import TCanvas, TGraph, TGraphErrors, TH2F
from ROOT import gROOT
#from ROOT import gStyle

import matplotlib.pyplot as plt
import matplotlib.dates

gROOT.SetStyle("Plain")
plt.ion()

filelist = []
if len(sys.argv) > 1:
    base_path = sys.argv[1]
else:
    print 'Usage:', sys.argv[0], '/your/search/path'

for base,subdirs,files in os.walk(base_path):
    for filename in files:
        #include only run files
        regex = re.search(r'\d\d\d\d\d\d\d\d\.FSC_CONTROL_VOLTAGE.fits',filename)
        #include run files and also the nightly file
        #regex = re.search(r'FTM_CONTROL_TRIGGER_RATES',filename)
        if regex:
            filelist.append(os.path.join(base,filename))


plotlist = ['FAD_Ud']
plotfmts = ['+:r']
per_name = []

for filename in filelist:

    print filename

    f = SlowData(filename)

    f.register("all")
    
    f.stack()
    for row in f:
        pass


    for name in plotlist:
        per_name.append(f.columns[name][0])

    fig = plt.figure()
    ax = fig.add_subplot(111)
    plt.hold(True)
    for i,name in enumerate(plotlist):
        for number in range(per_name[i]):
            print name, number
            Time = f.stacked_cols['Time']
            data = f.stacked_cols[name][:,number]
            med = np.median(Time)
            # get rid of Times of the previous day.
            Time_today = Time[np.where( Time>med-0.25 )[0]]
            data_today = data[np.where( Time>med-0.25)[0]]
#            if number == 0:
#                ax.plot_date( Time_today, data_today, fmt=plotfmts[i], label=name)
#            else:
#                ax.plot_date( Time_today, data_today, fmt=plotfmts[i])
            ax.plot_date( Time_today, data_today, fmt='.:', label=name+str(number))
    today_str = time.strftime('%d.%m.'  ,time.gmtime(Time_today[0]*24*3600))
    print today_str
    
    for i in range(10):
        print Time_today[i]
    
    plt.title('Voltage \n'+today_str)
    ax.xaxis.set_major_locator(
#        matplotlib.dates.HourLocator(byhour=range(24), interval=1)
        matplotlib.dates.AutoDateLocator()
    )
    ax.xaxis.set_major_formatter(
        matplotlib.dates.DateFormatter('%Hh')
#        matplotlib.dates.AutoDateFormatter()
    )
    plt.legend()
    plt.draw()

#    plt.ylim(12,41)
    plt.savefig(sys.argv[2])
