#!/usr/bin/python -tti

import time
from factdimserver import *
import numpy as np
import types

last_drive_kwargs = {}
last_drive_method = None

bias_calibration = {}

def wait_nice(self, state_num, timeout=None):                            
  if not hasattr(self, 'stn'):
    raise TypeError(self.name+' has no CMD called STATE')
  if timeout == None:
    timeout = float('inf')
  else:
    timeout = float(timeout)
  start = time.time()
  intermed = time.time()-1.
  while not self.stn == state_num:
    time.sleep(0.1)
    if time.time() - intermed >= 1.:
      print fad_control.events()[0], 'events @', ftm_control.trigger_rates()[3], 'Hz'
      intermed = time.time()
    
    if time.time() >= start+timeout:
      return False
  return True

fad_control.wait_nice = types.MethodType( wait_nice, fad_control) 


def FadConnectCrate( crate ):
  cratenum = None

  if crate == 'all':
    print "connecting to all crates"
    for i in range( 40 ):
      time.sleep(3.8)
      fad_control.connect(i)
    print "... done"
  else:
    try:
      cratenum = int(crate)
    except ValueError as e:
      print "cannot convert crate parameter to integer. crate=", crate
      print e
      raise

  if cratenum != None:
    print "connecting to crate", cratenum
    for i in range(cratenum*10, (cratenum+1)*10 ):
      time.sleep(3.8)
      fad_control.connect(i)
    print "... done"


def FadDisconnectCrate( crate ):
  cratenum = None

  if crate == 'all':
    print "connecting to all crates"
    for i in range( 40 ):
      fad_control.disconnect(i)
    print "... done"
  else:
    try:
      cratenum = int(crate)
    except ValueError as e:
      print "cannot convert crate parameter to integer. crate=", crate
      print e
      raise

  if cratenum != None:
    print "connecting to crate", cratenum
    for i in range(cratenum*10, (cratenum+1)*10 ):
      print 'disconnecting from i', time.time()
      fad_control.disconnect(i)
    print "... done"



def IsReadyForDataTaking():
  """ Checking the system statuses if they are ready for data taking
  """

  print "--------------------------------------"
  print "Checking the system statuses of:"
  print "FEEDBACK, BIAS and FAD"
  print "--------------------------------------"

  print "...waiting for FEEDBACK"
  print "   to be in state 12: CurrentControl"
  feedback.wait(12)

  print "...waiting for BIAS_CONTROL"
  print "   to be in state 9: VoltageOn"
  bias_control.wait(9)

  print "...waiting for FAD_CONTROL"
  print "   to be in state 4: Connected"
  fad_control.wait(4)
  
  print "...system statuses OK"
  print "--------------------------------------"

def NotReadyForDataTaking( servers_n_targets = [ (feedback, 12),
      (bias_control, 9),
      (fad_control, 4) ] ):
  """ Checking the system statuses if they are ready for data taking
    return list of servers, which are NOT ready for Data Taking
    so one can use this function like this
    if not NotReadyForDataTaking():
      # freak out
    else:
      # start data taking
  """
  not_ready = []
  
  print "--------------------------------------"
  print "Checking the system statuses of:"
  for server,target in servers_n_targets:
    print server.__name__ , ','
  print 
  print "--------------------------------------"

  for n, server, target in enumerate(servers_n_targets):
    if server.stn != target:
      print server.__name__, "NOT in state ", target
      not_ready.apppend((server,target))
  
  return not_ready



def IsTracking():
  """ Name is misleading, it actually *waits* until Drive is in Tracking
  original comment: Checking if Drive is in Status Tracking
  """
  
  #return drive_control.stn == 8
  drive_control.wait(8)
  

def PrepareBiasForDataTaking():
  """ should have the original behaviour, no new fancy features
    check feedback state before switching BIAS ON and ramping up to nominal Voltage
  """

  start = time.time()
  while (feedback.stn != 12):
    time.sleep(0.1)
    if time.time() > start + 10.:
      print "==================================================="
      print " feedback is not in state 'CurrentControl' "
      print " OPERATOR: "
      print " goto feedback console and check the state of "
      print " feedback by typing [st] to find out what the"
      print " current state means and maybe needs to be done"
      print " this script will wait for state 'CurrentControl'"
      print "==================================================="
      feedback.wait(12)

  bias_control.set_global_dac(1)

  start = time.time()
  while (bias_control.stn != 9):
    time.sleep(0.1)
    if time.time() > start + 10.:
      print '==================================================='
      print ' switching on bias not successfull'
      print ' biasctrl is not in state "VoltageOn"'
      print ''
      print ' OPERATOR:'
      print ' goto biasctrl console and check the state of'
      print ' biasctrl by typing [st] to find out what the'
      print ' current state means and maybe needs to be done'
      print ''
      print ' this script will wait for state "VoltageOn"'
      print '==================================================='
      bias_control.wait(9)

  bias_control.wait(5)
  bias_control.wait(9)

  print "bias is on, and feedback-program is working, but we wait 45sec for the current readings..."
  time.sleep(45)
  print "...done"


def StopTracking():
  """ should have the original behaviour, no new fancy features
    stop drivectrl tracking the current source
  """
  drive_control.stop()
  drive_control.wait(6) #Armed

  print "Drive Armed"
  print "Tracking Stopped"


def SwitchOnBias():
  """ should have the original behaviour, no new fancy features
    bring Feedback to state CurrentControIdle and switch on Bias
  """
  print ' switching on current controll feedback'
  feedback.stop()
  print ' ... starting current control feedback '
  feedback.start_current_control(0.)
  feedback.enable_output(1)  # 1 means True here ... this needs improvement.

  print ' ...waiting for FEEDBACK to be in state 9: CurrentCtrlIdle'
  feedback.wait(9)
  print '... feedback is running.'
  
  print ' switching bias on by, setting DAC to 1 globally'
  bias_control.set_global_dac(1)
  
  print ' ...waiting for BIAS to be in state 9: VoltageOn'
  bias_control.wait(9)
  print ' ...1 DAC globally set'


  print ' ...waiting for BIAS to be in state 5: Ramping'
  bias_control.wait(5)
  print ' ...ramping to nominal voltage'

  print ' ...waiting for BIAS to be in state 9: VoltageOn'
  bias_control.wait(9)
  print ' ...bias on'

  print ' waiting 45sec for the current control to stabilize...'
  time.sleep(45.)
  print ' ... done, bias on'


    # the feedback should be in state 'CurrentCtrlIdle'(9) now since 30.05.12
  #  if feedback.stn != 9:
  #    print "feedback is in state:", feedback.sts , "(", feedback.stn, ")"
  #    print "but is should be in state CurrentCtrlIdle (9)"
  #    print "aborting"
  #    return



def waitForTracking():
  """ Wait for drivectrl to reply that its tracking the given source
  """
  
  print "...waiting for DRIVE_CONTROL"
  print "   to be in state 7: Moving"
  drive_control.wait(7)
  print "...moving"
  
  print "...waiting for DRIVE_CONTROL"
  print "   to be in state 8: Tracking"
  drive_control.wait(8)
  print "...tracking requested wobble position"

  print "waiting 10 sec for drive to calm down"
  print "and tracking beeing stable"
  time.sleep(10)


def TakeDataRun():
  """ Take a 5min Data Run
  """
  # check if all subsystems are in the correct state  
  IsReadyForDataTaking()

  print ' taking Data:FullTriggerArea 5min Run ...'
  mcp.start( 300, -1, 'data\0')

  print '...waiting for FAD to be in state 8: Writing Data'
  fad_control.wait(8) # Writing Data
  print '...waiting for FAD to be in state 4: Connected'
  fad_control.wait(4) # Connected
  print '... done'

def TakeExtLpRun():
  """ Take a external Lightpulser Run
  """
  # check if all subsystems are in the correct state
  IsReadyForDataTaking()

  print 'taking External Light Pulser with BIAS on 1000 ...'
  mcp.start(-1, 1000, 'light-pulser-ext\0')

  print '...waiting for FAD to be in state 8: Writing Data'
  fad_control.wait(8) # Writing Data
  print '...waiting for FAD to be in state 4: Connected'
  fad_control.wait(4) # Connected
  print '... done'
  
def TakePedestalOnRun():
  """ Take a Pedestal 1000 run with Bias ON
  """
  # check if all subsystems are in the correct state
  IsReadyForDataTaking()

  print 'taking External Light Pulser with BIAS on 1000 ...'
  mcp.start(-1, 1000, 'pedestal\0')

  print '...waiting for FAD to be in state 8: Writing Data'
  fad_control.wait(8) # Writing Data
  print '...waiting for FAD to be in state 4: Connected'
  fad_control.wait(4) # Connected
  print '... done'


def Take( time, num_events, runtype):
  """ more general version of e.g. TakePedestalOnRun
    Note: One has to check, if Ready for *Take* by oneself
  """
  runtype += '\0'
  # check if all subsystems are in the correct state
  #IsReadyForDataTaking()

  print ' taking', runtype,'. ', num_events, 'events in', time, 'seconds'
  mcp.start(time, num_events, runtype)

  print '...waiting for FAD to be in state 8: Writing Data'
  fad_control.wait(8) # Writing Data
  print '...waiting for FAD to be in state 4: Connected'
  fad_control.wait(4) # Connected
  print '... done'


def TakeData():
  """ taking a Data Set (1x Pedestal On, 1x LPext, 4x5min DataRun)
  """
  # take a Pedestal run
  IsTracking()
  TakePedestalOnRun()
  
  # take a ExtLP run
  IsTracking()
  TakeExtLpRun()

  #Data Taking with Full Trigger Area (4x5min)
  for run in range(4):
    print 'taking data run', run+1, 'out of 4'
    IsTracking()
    TakeDataRun()

def TakeDrsCalibration():
  """ script for DRS-Calibration before Data taking
  """
  print 'script for DRS-Calibration before Data taking'
  print 'starting up...'

  feedback.enable_output(1)
  # Making sure bias is off, before the DRS calibration starts
  bias_control.set_zero_voltage()
  print '...ramping Voltage down'
  print ' ...waiting for BIAS to be in state 7: Voltage Off'
  bias_control.wait(7) #VoltageOff
  print '...BIAS voltage is switched off'

  # starting the DRS calibration
  fad_control.start_drs_calibration()

  # taking first DRS:Pedestal with 1000 Events and ROI 1024
  print 'taking DRS:Pedestal 1000 ...'
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'drs-pedestal')

  # taking DRS:Gain with 1000 Events and ROI 1024
  print ' taking DRS:Gain 1000 ...'
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'drs-gain')

  # taking DRS:Pedestal 1000 Events and ROI 1024
  print 'taking DRS:Pedestal 1000 ...'
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'drs-pedestal')
  
  print ' ... done'

  # taking again a DRS:Pedestal with 1000 Events and ROI 1024 for a crosscheck of calculated calibrations constants
  print ' taking crosscheck DRS:Pedestal 1000 ...'
  fad_control.set_file_format(2)
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'drs-pedestal')


  # taking DRS:Time with 1000 Events and ROI 1024
  print ' taking DRS:Time 1000 ...'
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'drs-time')
  

  # taking DRS:Time upshifted 1000 Events and ROI 1024
  print 'taking DRS:Time upshifted 1000 ...'
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'drs-time-upshifted')

  # taking a Pedestal with 1000 Events and ROI 300 for secondary baseline...
  print 'taking Pedestal 1000 for secondary baseline... with ROI=300'
  fad_control.reset_secondary_drs_baseline()
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'pedestal')

  # taking crosscheck Pedestal 1000 Events and ROI 300
  print ' taking crosscheck Pedestal 1000 ...with ROI=300'
  fad_control.set_file_format(2)
  fad_control.wait(4) #Connected
  Take(-1, 1000, 'pedestal')

  print '----------------------------------------------------'
  print 'This is the end of the'
  print 'DRS-Calibration before Data taking'
  print '----------------------------------------------------'

def DataTaking1():
  """ Script for taking data when you are tracking wobble position 1
    take a DRS CaLibration and physics Data afterwards
  """
  # Move Telescope to Wobble Position 1
  print '--------------------------------------'
  print 'data taking for Wobble 1'
  print 'starting up...'
  print '--------------------------------------'
  print 'OPERATOR:'
  print 'make sure the telescope is tracking'
  print 'wobble position 1 of the source'
  print '--------------------------------------'

  # Take a DRS-Calibration before beginning to take physics Data
  #TakeDrsCalibration()

  # check feedback state before switching BIAS ON and ramping up to nominal Voltage
  PrepareBiasForDataTaking()

  # taking a Data Set (1x Pedestal 1000 Bias On, 1x LPext 1000, 4x5min DataRun)
  TakeData()

  print '--------------------------------------'
  print 'data taking for Wobble 1 finished'
  print '--------------------------------------'

def DataTaking2():
  """ Script for taking data when you are tracking wobble position 2
  """
  # Move Telescope to Wobble Position 2
  print '--------------------------------------'
  print 'data taking for Wobble 2'
  print 'starting up...'
  print '--------------------------------------'
  print '--------------------------------------'
  print 'OPERATOR:'
  print '+ make sure the telescope is tracking'
  print '  wobble position 2 of the source'
  print '+ Measure Sky Brightness'
  print '--------------------------------------'


  # taking a Data Set (1x Pedestal 1000 Bias On, 1x LPext 1000, 4x5min DataRun)
  TakeData()

  print '--------------------------------------'
  print 'data taking for Wobble 2 finished'
  print '--------------------------------------'

def TrackCrabWobble1(): 
  """ changing tracking to "Crab" Wobble 1
  """
  print 'moving telescope to wobble position 1'
  print '...waiting for DRIVE_CONTROL'
  print '   to be in state 6: Armed'

  drive_control.wait(6) #Armed
  print 'DRIVE: ARMED'
  time.sleep(5.)

  drive_control.track_source( 0.6, 50, 'Crab\0')
  # we store this command in global vars, so it is increadibly easy, to 
  # do this call again, when needed
  last_drive_method = drive_control.track_source
  last_drive_kwargs = { 'wobble_offset' : 0.6,
                          'wobble_angle' : 50,
                          'source_name' : 'Crab\0' }
  # so in case, this call needs to be repeated, just do
  # last_drive_method(**last_drive_kwargs)
  
  print '...sent tracking command for Crab Wobble 1'
  print 'COMMAND: DRIVE_CONTROL/TRACK_SOURCE 0.6 50 Crab'

def TrackCrabWobble2(): 
  """ changing tracking to "Crab" Wobble 2
  """
  print 'moving telescope to wobble position 2'
  print '...waiting for DRIVE_CONTROL'
  print '   to be in state 6: Armed'

  drive_control.wait(6) #Armed
  print 'DRIVE: ARMED'
  time.sleep(5.)

  # we store this command in global vars, so it is increadibly easy, to 
  # do this call again, when needed
  last_drive_method = drive_control.track_source
  last_drive_kwargs = { 'wobble_offset' : 0.6,
                          'wobble_angle' : -130,
                          'source_name' : 'Crab\0' }
  # so in case, this call needs to be repeated, just do
  last_drive_method(**last_drive_kwargs)
  
  print '...sent tracking command for Crab Wobble 2'
  print 'COMMAND: DRIVE_CONTROL/TRACK_SOURCE 0.6 -130 Crab'



def FirstDrsCalib( SkipCurrentCalib=False ):
  """ performs the everything, which is done in the FirstDrsCalib Script as well . 
  """
  # As a First step we want to calibrate the current, which are read from the bias crate,
  # and not take a DRS calibration, as it is mentioned in the data taking page...
  # so for this we should get the feedback and biasctrl programs into known states
  # I think it is good to try a RECONNECT to the bias, and make sure the voltage is off
  # Since we do not know, what the feedback program is doing at the moment, we should as well,
  # tell it to keep its mouth shut ... just to be sure, we know whats going on
  print "stopping feedback"
  feedback.stop()

  time.sleep(2)
  # stopping should always be possible, and end in state 'Connected'(6)
  print " ...waiting for FEEDBACK to be in state 6: Connected"
  feedback.wait(6)
  print "..done"

  #BIAS_CONTROL/RECONNECT
  # If we were disconnected, and this was the first try of the night, the bias_ctrl should
  # be in state 'VoltageOff'(7) more or less immediately
  #.s BIAS_CONTROL 3
  #.s BIAS_CONTROL 7 5000
  # if these assumptions are all wrong, then we might have been properly connected anyway,
  # and just have to ramp down... lets do it, but wait forever, in case it does not work
  print " switching off bias"
  bias_control.set_zero_voltage()
  time.sleep(2)
  print " ...waiting for BIAS to be in state 7: VoltageOff"
  bias_control.wait(7)
  print " ...done"

  if not SkipCurrentCalib:
    # in case we reach this line, the voltages are all off, and the feedback does not do anything
    # So lets do the current calibration, therefor we tell the bias crate to ramp up just 1 single DAC count(~22mV)
    # the result of this action is, to get bias_ctrl into the state 'VoltageOn'(9), but since we only go one DAC count it shouldn't take long
    print " setting bias globally to 1 DAC"
    bias_control.set_global_dac(1)

    time.sleep(2)
    print " ...waiting for BIAS to be in state 9: VoltageOn"
    bias_control.wait(9)
    print " ...done"

    # now we may tell the feedback program to calibrate the currents ...
    # I do not understand, if I have to explicitely allow the feedback program to generate output,
    # or if it just produces output...
    # As far as I understand, the feedback output enable status is the same,
    # as it was before I send the STOP command... so it is unknown at this point.
    # and in addition enabling or disabling the output, when STOPed is not possible as far as I know...
    # I try to enable it anyway.
    print " enabling output for feedback"
    feedback.enable_output(1)
    time.sleep(2)
    print " ...done"

    print " calibrating bias crate current readings..."
    feedback.calibrate_currents()
    time.sleep(5)
    # in order to find out when the calibration ends, we have to wait for the transistion from state
    # 'Calibrating'(13) back to 'Connected'(6)
    print " ...waiting for FEEDBACK to be in state 13: Calibrating"
    feedback.wait(13)
    print " ...waiting for FEEDBACK to be in state 6: Connected"
    feedback.wait(6)

    # Thomas Bretz told me, that the feedback, after this is step has disabled its output
    # and is in the mode, we might call 'temperature control' even there is no temerature beeing controlled.
    # I don't know where the voltage is ... in order to perform the calibration, the feedback had to
    # ramp up to 2V below the operational voltage, i.e. about 1V below the breakdown voltage

    # We want to take a DRS amplitude calibration so we have to ramp down the bias voltage.
    # this 10sec wait is needed in order for the bias not to disconect all the time...
    print " ... current calibration done"
    time.sleep(10)

    print " switching off bias"
    bias_control.set_zero_voltage()
    time.sleep(5)
    print " ...waiting for BIAS to be in state 7: VoltageOff"
    bias_control.wait(7)
    print " ...done"

  # So now we can take the 3 runs, which are called DRS amplitude calibration:
  # A pedestal run with ROI=1024
  # A gain calibration run with ROI=1024
  # and a second pedestal run, with the same ROI as our next data will be, i.e. ROI=300 in this case
  print "taking DRS:Pedestal 1000 ..."
  print "==================================================="
  print "OPERATOR: "
  print "observe Events tab and make sure there are no patches "
  print "with strange behaviour, which can be caused "
  print "by DRS-CHIP Problems"
  print "==================================================="

  fad_control.start_drs_calibration()
  time.sleep(0.5)
  mcp.start(-1, 1000, "drs-pedestal\0")

  print "...waiting for FAD to be in state 8: Writing Data"
  fad_control.wait(8)
  print "...waiting for FAD to be in state 4: Connected"
  fad_control.wait_nice(4)
  print "... done"

  print "taking DRS:Gain 1000 ..."
  mcp.start(-1, 1000, 'drs-gain\0')
  print "...waiting for FAD to be in state 8: Writing Data"
  fad_control.wait(8)
  print "...waiting for FAD to be in state 4: Connected"
  fad_control.wait_nice(4)
  print "... done"

  time.sleep(2)
  if GetDrsCalibGainRms():
    print
    print 'First DRS Calib Script will be aborted'
    print 'operator, please power cycle FACT'
    return False

  print "taking Pedestal 1000 ..."
  mcp.start( -1, 1000, 'pedestal\0')
  print "...waiting for FAD to be in state 8: Writing Data"
  fad_control.wait(8)
  print "...waiting for FAD to be in state 4: Connected"
  fad_control.wait(4)
  print "... done"

  # okay this is the DRS calibration for the next few runs.
  # we are now asked to take again a pedestal run, which can be used, to
  # calculate the electronics noise for instance ... since the shutter is closed and the
  # voltage is off .. there should not be alot of signal in it :-)
  print "taking crosscheck Pedestal 1000 ..."
  fad_control.set_file_format(2)

  mcp.start(-1, 1000, 'pedestal\0')
  print "...waiting for FAD to be in state 8: Writing Data"
  fad_control.wait(8)
  print "...waiting for FAD to be in state 4: Connected"
  fad_control.wait(4)
  print "... done"

  # now we want to take a run, with dark counts events
  # so we need to ramp up the voltage
  # we want to use the 'current control' more so we give the commands for this...
  print "switching on current controll feedback ..."
  feedback.stop()
  feedback.start_current_control(0.0)
  feedback.enable_output(1)
  # the feedback should be in state 'CurrentControl'(12) now
  # the feedback should be in state 'CurrentCtrlIdle'(9) now since 30.05.12
  print "...waiting for FEEDBACK to be in state 9: CurrentCtrlIdle"
  feedback.wait(9)
  print "... done"
  print "switching on bias"
  # now we give the feedback a hint, that it may ramp ...
  bias_control.set_global_dac(1)
  # after this command the bias_ctrl should be in state 'VoltageOn'(9) after a second or so
  print "...waiting for BIAS to be in state 9: VoltageOn"
  bias_control.wait(9)
  print "...1 DAC globally set"
  # then usually it takes some time until the feedback has enough information to really start controlling the voltage
  # when the feedback actually kicks in, the bias is first in state 'Ramping'(5) for some seconds and finally in 'VoltageOn'(9)
  # again
  print "...waiting for BIAS to be in state 5: Ramping"
  bias_control.wait(5)
  print "...ramping to nominal voltage"
  print "...waiting for BIAS to be in state 9: VoltageOn"
  bias_control.wait(9)
  print "...bias on"
  # here we should wait 45 sec in order for the current control to get enough current readings and temp readings to stabilize..
  print "waiting 45sec for the current control to stabilize..."
  time.sleep(45)
  print "... done"

  # so now we can take the dark count run ...
  # this might be changed in the future ... either the number of events or the the ROI might be changed
  # then the DRS calibration above, and the pedestal run in between have to be changed as well.
  print "taking Pedestal with BIAS on 3000 ..."
  mcp.start(-1, 3000, 'pedestal\0')
  print "...waiting for FAD to be in state 8: Writing Data"
  fad_control.wait(8)
  print "...waiting for FAD to be in state 4: Connected"
  fad_control.wait(4)
  print "... done"

  # at the end the bias voltage should be ramped down, since in a few seconds a shifter wit ha flashlight
  # will come out to open the shutter...
  print "switching OFF bias ..."
  bias_control.set_zero_voltage()
  print "...waiting for BIAS to be in state 7: VoltageOff"
  bias_control.wait(7)
  print "...done"
  print "This is the end of First DRS Calibration"
  print "----------------------------------------------------"
  print ">"

def Ratescan( ra=None, dec=None, sourcename=None):
  """
# call it by: .x ScriptsForDimCtrl/Ratescan.dim mode=<trackmode> ra=<Right ascension> dec=<Declination> source=<source_name>
# mode=0: Manual tracking Mode: set tracking in drivectrl manually
# mode=1: Coordinate Mode: scripts sends tracking command to drivectrl with the given RaDec coordinates
# mode=2: source Mode: scripts sends tracking command to drivectrl with the given source_name

  """
  print '======================================'
  print 'RATESCAN'
  print '======================================'
  print 'Preparing Drive'


  if None == ra and None == dec and None == sourcename:
    print 'Manual tracking Mode'
    print '---------------------'
    print 'OPERATOR'
    print 'change tracking in drivectrl manually'
    print 'script will wait for drive'
    print 'to be in state tracking'
  elif None != ra or None != dec:
    try:
      ra = float(ra)
      dec = float(dec)
    except TypeError:
      raise
      
    print '...stop tracking'
    StopTracking()
    print '...change tracking of telescope to:'
    print '...Ra  = ', ra
    print '...Dec = ', dec
    drive_control.track( ra, dec)
  elif None != sourcename:
    print '...stop tracking'
    StopTracking()
    print '...change tracking of telescope to:', sourcename
    sourcename += '\0'
    drive_control.track_source( 0, 0, sourcename)
  else:
    print 'type(ra)', type(ra), '\tra', ra
    print 'type(dec)', type(dec), '\tdec', dec
    print 'type(sourcename)', type(sourcename), '\tsourcename', sourcename
    raise ValueError('RateScan does not know what to do with its parameters. Bug!')
    return False

  IsTracking()
  IsReadyForDataTaking()

  print 'Starting Ratescan'
  print '...waiting for Ratescan'
  print '   to be in state 4: Connected'
  

  if not rate_scan.wait(4, timeout=5.): #Connected
    # we went into timeout!
    print 'Rate_Scan not in correct state'
    print 'OPERATOR:'
    print '+ check connection to ftm control'
    print 'we went into to 5sec. timeout while waiting for RATE_SCAN to be in state Connected'
    print 'aborting'
    return False
    
  rate_scan.start_threshold_scan( 50, 1000, -10)
  if not rate_scan.wait( 6, timeout=10.): # Statename???
    # we went into timeout
    print 'ratescan not started'
    print 'we went into 10sec. timeout while waiting for RATE_SCAN to start the Scan'
    print 'aborting'
    return False
    
  print '...processing ratescan'
  if not rate_scan.wait( 4, timeout=2700.): # Connected
    # we went into timeout
    print 'we went into 2700sec. timeout while waiting for RATE_SCAN to finish'
    print 'aborting'
    return False

  print 'Ratescan finished successfully'
  return True
  

def ResetCrate( crate_num ):
  """ Reset Crate
    crate_num = 0,1,2 or 3  the number of the crate to reset.
    crate_num = 'all' is NOT YET SUPPORTED
  """
  c = int(crate_num)
  
  print '======================================'
  print 'Crate-Reset for crate ', c
  print '======================================'

  print '...resetting MCP'
  mcp.reset()
  time.sleep(5.)
  print '...diconnecting FAD boards of crate ', c
  FadDisconnectCrate( c )
  time.sleep(2.)

  print '...disconnecting All FTUs'
  ftm_control.enable_ftu( -1, 0) # -1 for all, and 0 for False
  time.sleep(2.)

  print '...checking state of FTM_Control'
  print '...waiting for state 3: Idle'
  if not ftm_control.wait(3, 2.): # Idle
    print '...stopping trigger'
    ftm_control.stop_trigger()
    ftm_control.wait(3) # wait for Idle endlessly

  print '...resetting crate'
  ftm_control.reset_crate( c )
  time.sleep(2.)

  print '...connecting All FTUs'
  ftm_control.enable_ftu( -1, 1) # -1 for all, and 1 for yes, or True
  time.sleep(4.)
  
  print '...pinging FTUs'
  ftm_control.ping()

  print '...connecting FAD boards of crate', c
  FadConnectCrate(c)
  print '======================================'
  print 'Crate-Reset for crate', c, 'finished'
  print '======================================'

def GetDrsCalibGainRms():
#drs_calibration(self) method of factdimserver.FAD_CONTROL instance
#DESC in SERVICE_DESC is empty ?!
#I:1;I:3;F:1474560;F:1474560;F:1474560;F:1474560;F:1474560;F:1474560;F:163840;F:163840
  data = fad_control.drs_calibration()
  N1 = data[0]
  N3 = data[1:4]
  OffsetMean = np.array(data[4:4+1024*1440]).reshape(1440,1024)
  OffsetRms = np.array(data[4+1024*1440:4+1024*1440*2]).reshape(1440,1024)
  GainMean = np.array(data[4+1024*1440*2:4+1024*1440*3]).reshape(1440,1024)
  GainRms = np.array(data[4+1024*1440*3:4+1024*1440*4]).reshape(1440,1024)

  gr = GainRms.mean(axis=1)
  lala = np.zeros(len(gr)/9)
  for i,v in enumerate(lala):
    lala[i] = gr[i*9:(i+1)*9].mean()

  # outliers
  mean = lala.mean()
  std = lala.std()

  print 'Mean DRS GainRms value:', mean
  print 'std:', std
  outs = np.where( lala > mean+7*std)[0]
  if len(outs) > 0:
    print 'WARNING possible DRS underflow detected!!!'
    for out in outs:
      out = int(out)
      crate= out/40
      board = (out-40*crate)/4
      chip = out-40*crate-4*board
      print 'possible DRS underflow in DRS:', crate, board, chip, '--> Mean-GainRms:', lala[out]
      return outs
  else:
    return False




def GetBiasCalibration():
  cali = feedback.calibration()
  bias_calibration['Time'] = time.time()
  bias_calibration['Calibration'] = cali

def GetBiasCurrent(verbose = False):
  """ return median, std, max and min current
  """
  if 'Time' in bias_calibration:
    cali = bias_calibration['Calibration']
  else:
    GetBiasCalibration()
    cali = bias_calibration['Calibration']

  r = np.array(cali[2*416:2*416+320])

  bias = bias_control

  I = np.array(bias.current()[0:320], dtype=float)
  II = I/4096. * 5000
  V = np.array(bias.voltage()[0:320])
  if len(sys.argv) > 1:
      i = int(sys.argv[1])
  else: i=0
#  print 'I:', I[i], 'dac\t', II[i], 'uA'
#  print 'V:', V[i]
#  print ''
#  print 'GUI offset:', V[i]/r[i]*1e6
#  print 'GUI feedback:', II[0] - V[0]/r[0]*1e6

  GUII = II-V/r*1e6
  if verbose:
    print 'median', np.median(GUII)
    print 'mean', GUII.mean()
   # print 'rms', ((GUII- GUII.mean())**2).sum()
    print 'std', GUII.std()
    print 'max', GUII.max()
    print 'min', GUII.min()

  return GUII.mean(), GUII.std(), GUII.max(), GUII.min()

def TakeCrab():
  """ Data taking and tracking script for Crab
  """
  print '======================================'
  print 'Data taking and tracking script for'
  print 'Crab'
  print '======================================'
  print 'starting up...'

  # changing tracking to Crab Wobble 1
  TrackCrabWobble1()

  # Wait for drivectrl to reply that its tracking the given source
  WaitForTracking()

  DataTaking1()

  # changing tracking to Crab Wobble 2
  TrackCrabWobble2()

  # Wait for drivectrl to reply that its tracking the given source
  WaitForTracking()

  # data taking to Crab Wobble 2
  DataTaking2()

  # Stop tracking
  StopTracking()

  print '======================================'
  print 'Data taking and tracking script for'
  print 'Crab FINISHED'
  print '======================================'
  


def TrackSourceWobbleX( sourcename, wobble_pos ):
  """ general Tracking function
  """
  wp = int(wobble_pos)
  if wp != 1 and wp != 2:
    raise ValueError('wobble_pos *must* be 1 or 2')
  
  if sourcename not in sourcedict:
    print sourcedict.keys()
    raise ValueError('sourcename: '+ sourcename +' must be in sourcedict.')

  print 'moving telescope to wobble position ', wp, 'of ', sourcename
  print '...waiting for DRIVE_CONTROL'
  print '   to be in state 6: Armed'

  drive_control.wait(6) #Armed
  print 'DRIVE: ARMED'
  time.sleep(5.)

  wobble_offset = sourcedict[sourcename]['wobble_offset']
  wobble_angle = sourcedict[sourcename]['wobble_angle'+str(wp)]
  sourcename += '\0'
  
  last_drive_method = drive_control.track_source
  last_drive_kwargs = { 'wobble_offset' : wobble_offset,
                          'wobble_angle' : wobble_angle,
                          'source_name' : sourcename }
  kwa = last_drive_kwargs
  last_drive_method(kwa['wobble_offset'], kwa['wobble_angle'], kwa['source_name'])
  
  print '... done'

source_list = [
  ['Crab', 0.6 , 50, -130],
  ["1ES 2344+51.4", 0.6 , 90, -90 ],
  ["Mrk 501", 0.6,  -22, -22+180 ],
  ["Mrk 421", 0.6, 90, -90 ],
  ["1ES 1218+304", 0.6, -5, -5+180 ],
  ["1ES 1959+650", 0.6,  155, 155-180 ],
  ["Dark Patch 2", 0.6 , 90, -90 ],
  ["Dark Patch 3", 0.6 , 90, -90 ],
  ["H 1426+428", 0.6 , 90, -90 ],
  ["IC 310", 0.6,  -18, -18+180 ],
  ["PKS 2155-304", 0.6,  90, -90 ] ]
  
sourcedict = {}

def make_sourcedict():
  for s in source_list:
    sourcedict[s[0]] = {}
    sourcedict[s[0]]['wobble_offset'] = s[1]
    sourcedict[s[0]]['wobble_angle1'] = s[2]
    sourcedict[s[0]]['wobble_angle2'] = s[3]


def TrackCrabWobble1_new(): 
  """ changing tracking to "Crab" Wobble 1
  """
  TrackSourceWobbleX( 'Crab', 1)

def TrackCrabWobble2_new(): 
  """ changing tracking to "Crab" Wobble 1
  """
  TrackSourceWobbleX( 'Crab', 2)


def TakeSource( name ):
  if name not in sourcedict:
    print name, 'not in dict of sources, possible sources are:'
    print sorted(sourcedict.keys())
    raise ValueError('wrong source name')
    
  TrackSourceWobbleX( name, 1) # Track Wobble pos 1 of source
  WaitForTracking()
  DataTaking1()

  TrackSourceWobbleX( name, 2) # Track Wobble pos 2 of source
  WaitForTracking()
  DataTaking2()
  
  StopTracking()

def PrintCurrents( x = 1.0):
  while True:
    time.sleep( x )
    print time.strftime('%d %b %Y %H:%M:%S UTC', time.gmtime()), GetBiasCurrent()

def WaitForTracking():
  drive_control.wait(7) #Moving
  drive_control.wait(8) #Tracking
  time.sleep(10)


if __name__ == '__main__':
  print 'Welcome to PyDimCtrl'
  make_sourcedict()
  print
  print 'possible sources:'
  print sorted( sourcedict.keys() )
