#include <iostream>
#include <fstream>
#include <stdlib.h>

#include "pulse.h"

using namespace std;
using namespace TMath;

Pulse::Pulse()
{
    mHisto          = NULL;
    mOptions        = "";
    mBsl            = 0;
    mHeight         = 0;
    mStart          = 0;
    mRising         = 0;
    mTauRising      = 0;
    mTauFalling     = 0;
    mIntegral       = 0;
    mAmplitude      = 0;
    mPhE            = 0;
}

Pulse::Pulse(TH1* histo)
{
    mHisto          = histo;
    mOptions        = "";
    mBsl            = 0;
    mHeight         = 0;
    mStart          = 0;
    mRising         = 0;
    mTauRising      = 0;
    mTauFalling     = 0;
    mIntegral       = 0;
    mAmplitude      = 0;
    mPhE            = 0;
}

Pulse::Pulse(TH1* histo, TString options)
{
    mHisto          = histo;
    mOptions        = options;
    mBsl            = 0;
    mHeight         = 0;
    mStart          = 0;
    mRising         = 0;
    mTauRising      = 0;
    mTauFalling     = 0;
    mIntegral       = 0;
    mAmplitude      = 0;
    mPhE            = 0;
}

Pulse::~Pulse()
{

}

void
Pulse::Fit(
        TString fitName,
        TString fitOptions
        )
{
    int     fitMin = mHisto->GetXaxis()->GetFirst();
    int     fitMax = mHisto->GetXaxis()->GetLast();

    Fit(
        fitName,
        fitOptions,
        fitMin,
        fitMax
    );
}

void
Pulse::Fit(
        TString fitName,
        TString fitOptions,
        int     fitMin,
        int     fitMax
        )
{
    TF1 fit(fitName, shapeFunc, fitMin, fitMax, 6 );

    // ======================================================================
    // Calculate startvaues for fit
    double tau      = 30.0;
    double bsl = 0; //MW der ersten zehn slices

    int first_bin   = mHisto->GetXaxis()->GetFirst();

    for (int i = 0; i < 10; i++){
        bsl += mHisto->GetBinContent(first_bin+0);
    }
    bsl = bsl/10;

    double stop     = mHisto->GetMaximumBin(); //pos of max
    double height   = mHisto->GetBinContent(stop);
    double start    = stop-10; //pos 10 slices before maximum
    double rising   = (stop - start)/tau;
    // ======================================================================

    double para[] = {bsl, height, start, stop, tau, tau};



    fit.SetParameters(para);
    fit.SetParNames("BSL", "Height", "Start", "Rising", "Tau1", "TauFalling");
    fit.SetLineColor(kRed);
    mHisto->Fit(&fit, fitOptions);

    mBsl            = fit.GetParameter(0);
    mHeight         = fit.GetParameter(1);
    mStart          = fit.GetParameter(2);
    mRising         = fit.GetParameter(3);
    mTauRising      = fit.GetParameter(4);
    mTauFalling     = fit.GetParameter(5);
}

void
Pulse::Fit2(
        TString fitName,
        TString fitOptions
        )
{
    int     fitMin = mHisto->GetXaxis()->GetFirst();
    int     fitMax = mHisto->GetXaxis()->GetLast();

    Fit2(
        fitName,
        fitOptions,
        fitMin,
        fitMax
    );
}

void
Pulse::Fit2(
        TString fitName,
        TString fitOptions,
        int     fitMin,
        int     fitMax
        )
{
    TF1 fit(fitName, shapeFunc2, fitMin, fitMax, 5 );

    // ======================================================================
    // Calculate startvaues for fit
    double tau      = 30.0;
    double bsl = 0; //MW der ersten zehn slices

    int first_bin   = mHisto->GetXaxis()->GetFirst();

    for (int i = 0; i < 10; i++){
        bsl += mHisto->GetBinContent(first_bin+0);
    }
    bsl = bsl/10;

    double stop     = mHisto->GetMaximumBin(); //pos of max
    double amplitude= mHisto->GetBinContent(stop);
    double start    = stop-10; //pos 10 slices before maximum
    // ======================================================================


    double para[] = {bsl, amplitude, start, tau, tau};
    fit.SetParameters(para);
    fit.SetParNames("BSL", "Amplitude", "Start", "Tau1", "TauFalling");
    fit.SetLineColor(kBlue);
    mHisto->Fit(&fit, fitOptions);

    mBsl            = fit.GetParameter(0);
    mAmplitude      = fit.GetParameter(1);
    mStart          = fit.GetParameter(2);
    mTauRising      = fit.GetParameter(3);
    mTauFalling     = fit.GetParameter(4);
}

double  Pulse::GetBsl(){ return mBsl;}
double  Pulse::GetHeight(){ return mHeight;}
double  Pulse::GetAvalancheStart(){ return mStart;}
double  Pulse::GetAvalancheEnd(){ return mRising;}
double  Pulse::GetTimeConstRising(){ return mTauRising;}
double  Pulse::GetTimeConstFalling(){ return mTauFalling;}
double  Pulse::GetIntegral(){ return mIntegral;}
double  Pulse::GetAmplitude(){ return mAmplitude;}
int     Pulse::GetPE(){ return mPhE;}

//double
int Heaviside(double val)
{
    if( val < 0)    return 0;
    if( val >= 0)   return 1;
}

//Pulse::
double shapeFunc(
        double*     t,
        double*     par
        )
{
    double returnval= 0.0;

    // name parameters
    double bsl      = par[0];
    double height   = par[1];
    double start    = par[2];
//    double rising   = par[3];
    double tau1     = par[4];
    double tau2     = par[5];
    double stop     = par[3];

    // helper variables
//    double max      = start + rising * tau1;
    double e1       = height * (1 - Exp(-(t[0]-start)/tau1 ) );
//    double e2       = (-1) * height * (1 - Exp(-(x[0]-max)/tau2 ) );
    double e2       = (-1) * height * (1 - Exp(-(t[0]-stop)/tau2 ) );
    // calculate return value
    returnval += bsl;

    if (t[0] > start)
        returnval += e1;
    if (t[0] > stop)
        returnval += e2;

    return returnval;
}

/*
[18:42:13] Dominik: können wir nachher skypen? haste n headset?
[18:47:34] Dominik: hallo?
[18:53:38] Dominik: so also ich hab das file glaubich gefunden
[18:54:04] Dominik: height ist schonmal nicht die amplitude des pulses.
[18:54:52] Dominik: der puls ist ja sozusagen aus 2 funkionen zusammen gesetzt
[18:55:08] Dominik: die erste funktion, in meinem skript damals e1 genannt
[18:55:22] Dominik: ist ja ne umgekehrte nach obenverschobene e-fkt
[18:55:54] Dominik: und so wie sich ne normale abfallende e-fkt der null annähert, so nähert sich meine e1 dem wert 'height' an
[18:56:11] Dominik: allerdings kommt nun noch die abfallende e-fkt e2 dazu,
[18:57:20] Dominik: im Allgemeinen legt e2 schon los, bevor e1 auch nur in die Nähe von 'height' kommt und beginnt die Kurve nach unten zu drücken.
[18:57:37] Dominik: height ist also ein Skalenparameter, der nicht anschaulich ist
[18:59:27] Dominik: aber ich vermute, wenn man die Funktion nimmt und wie inder 9ten klasse die ableitung macht um die Position und Höhe des Maximums zu bestimmen, dann geht 'height' als linearer Faktor in die Höhe ein und spielt für die Position des Maximums keine Rolle.
Wenn das so ist, dann ist 'height' eine gute Schraube für den Fit-Algorithmus.... aber anschaulich wie gesagt nicht.

p0 = [-1., 10., 50., 70, 30., 30.] # Initial guess for the parameters

bsl = p[0]      # just the baseline
    height = p[1]   # this is not the pulse height, but the maximum of the discharging edge
                    # it *would* be the pulse height only in case the
                    # recharging process would set in later...

    start = p[2]    # start of avalanche aka start of discharge of diode capacitance
    stop = p[3]     # stop of avalanche, or start of recharging of diode
    tau1 = p[4]     # time constant of discharging process
    tau2 = p[5]     # time constant of recharging process

*/


double shapeFunc2(
        double*     t,
        double*     par
        )
{
    double returnval= 0.0;

    // name parameters
    double bsl      = par[0];
    double gain     = par[1];
    double t_0      = par[2];
    double tau1     = par[3];
    double tau2     = par[4];

    // helper variables
    double e1       = 1 - Exp(-(t[0]-t_0)/tau1 ) ;
    double e2       = Exp(-(t[0]-t_0)/tau2 ) ;

    // calculate return value
    returnval += bsl;
    returnval += gain*e1*e2*Heaviside(t[0]-t_0);

    return returnval;
}

