#ifndef Pulse_H
#define Pulse_H

// SYSTEM INCLUDES
//

// PROJECT INCLUDES
#include <TROOT.h>
#include <TMath.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TF1.h>
#include <TString.h>
#include <TSystem.h>
//

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/**
*/
int     Heaviside(double val);
double  shapeFunc(   double* t, double* par);
double  shapeFunc2(  double* t, double* par);

class Pulse
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    Pulse( );
    Pulse(TH1* histo );
    Pulse(TH1* histo, TString options );

    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */
    /** Destructor.
    */
    ~Pulse();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS
//    double shapeFunc( double* x, double* par);
    void    Fit(TString fitName, TString fitOptions );
    void    Fit(TString fitName, TString fitOptions, int fitMin, int fitMax);
    void    Fit2(TString fitName, TString fitOptions );
    void    Fit2(TString fitName, TString fitOptions, int fitMin, int fitMax);

// ACCESS
    double  GetBsl();
    double  GetHeight();
    double  GetAvalancheStart();
    double  GetAvalancheEnd();
    double  GetTimeConstRising();
    double  GetTimeConstFalling();
    double  GetIntegral();
    double  GetAmplitude();
    int     GetPE();

// INQUIRY
private:
    TH1*    mHisto;
    TString mOptions;
    double  mBsl;
    double  mHeight;
    double  mStart;
    double  mRising;
    double  mTauRising;
    double  mTauFalling;
    double  mIntegral;
    double  mAmplitude;
    int     mPhE;

};

#endif // Pulse_H
