#!/usr/bin/python

from pyfact import RawData
from pylab import *
import numpy as np
from scipy import *
import os.path
from coor import Coordinator



class EventBrowser:
    
    def __init__(self, run, nevents = 100):
        map_file_path = '../../map_dn.txt'
        path = os.path.abspath(__file__)
        path = os.path.dirname(path)
        map_file_path = os.path.join(path, map_file_path)
        if not os.path.isfile(map_file_path):
            print 'not able to find file:', map_file_path
            sys.exit(-2)
        
        chid, y,x,ye,xe,yh,xh,softid,hardid = np.loadtxt(map_file_path ,unpack=True)
        self.xe = xe
        self.ye = ye
        self.H = (6,0,30./180.*3.1415926)
        self.H = (6,0,0)
   
        self.coor = Coordinator()
   
        self.run = run
       
        self.event = run.next()
        self.nevents = nevents
        
        self.fig = figure(figsize=(6, 8), dpi=80)
        self.axup = self.fig.add_axes([0.1,0.3,0.8,0.6])
        
        
        self.axdn = self.fig.add_axes([0.1,0.,0.8,0.25])
        self.axup.grid(True)
        data = np.zeros(1440)
        result = self.axup.scatter(xe,ye,s=38,alpha=1,
                            c=data, marker=self.H, linewidths=1.)
        self.axup.axis([-21,21,-21,21])

                
        #qself.axdn = self.fig.add_subplot(212)
        
        self.fig.canvas.mpl_connect('key_press_event', self.onpress)
        self.fig.canvas.mpl_connect('button_press_event', self.onclick)
        
               
        self.axdn.set_axis_off()
       
        text = "Event Browser, press 'n' iterate over the events.\n"
        text += "Event id: 0\n"
        text += "Trigger type: 0"
                
        self.axdn.annotate(text, (0.01, 0.5),
                         xycoords="axes fraction", va="center", ha="left",
                         bbox=dict(boxstyle="round, pad=1", fc="w"))
        
        setp(self.axdn.get_xticklabels(), visible=False)
        setp(self.axdn.get_yticklabels(), visible=False)

    def onclick(self, button_press_event):
        
        self.axdn.cla()
        self.axdn.set_axis_off()
        
        euc2chid = self.coor.euc2chid
        pixel_centers = euc2chid.keys()
        
        mouse = (button_press_event.xdata, button_press_event.ydata)
        
        diffs = np.zeros(len(pixel_centers))
        for i,pixel in enumerate(pixel_centers):
            diffs[i]= np.sqrt((mouse[0]-pixel[0])**2 + (mouse[1]-pixel[1])**2)

        chid = euc2chid[pixel_centers[np.argmin(diffs)]]
        
        
        
        text = "Event Browser, press 'n' iterate over the events.\n"
        text += "Event id: 0\n"
        text += "Trigger type: 0"
        text += '\nx' + str(button_press_event.xdata) + '   '
        text += 'y' + str(button_press_event.ydata) + '   '
        text += 'inaxes' + str(button_press_event.inaxes) + '   '
        text += 'chid' + str(chid) + '   '
        
        text += 'button' + str(button_press_event.button)
        
         
        print button_press_event
       
   
        self.axdn.annotate(text, (0.01, 0.5),
                         xycoords="axes fraction", va="center", ha="left",
                         bbox=dict(boxstyle="round, pad=1", fc="w"))
         
       

        self.fig.canvas.draw()
        show()

        
    def onpress(self, event):
        'define some key press events'
        
        if self.event['event_id'] > self.nevents: return

        if event.key in ('q','Q'): sys.exit()

        if event.key not in ('n', 'p'): return
        if event.key=='n': 
            self.event = self.run.next()
        else:  
            print "Sorry I cannot go back!"
            return
     
        
        #self.ax.cla()
        #self.ax.set_axis_off()
         
        text = "Event Browser, press 'n' in this window to iterate over the events.\nEvent id: "+str(self.event['event_id'])
        text = text + "\nTrigger type: "+str(self.event['trigger_type'])
                
       
   
        #self.ax.annotate(text, (0.01, 0.5),
        #                 xycoords="axes fraction", va="center", ha="left",
        #                 bbox=dict(boxstyle="round, pad=1", fc="w"))
         
        self.update()
    
    def update(self):
        
        if self.event['event_id'] > self.nevents: return
        
        dataind = self.event['event_id']
        
        # put a user function in here!        
        self.userfunc(dataind)

        self.fig.canvas.draw()
        show()

    def userfunc(self,dataind):
        print 'No userfunc defined'
        pass
    

#event = run.next()

if __name__ == '__main__':
    datafilepath = '/fact/raw/2012/06/05/20120605_016.fits.gz'
    calibfilepath = '/fact/raw/2012/06/05/20120605_012.drs.fits.gz'
    run = RawData(datafilepath, calibfilepath)
    
    if len(sys.argv) < 2:
        print "Usage: testFFT.py pixelID neventsmax"
        sys.exit()

    pixelID = int(sys.argv[1])
    neventsmax = int(sys.argv[2])
       
    eb = EventBrowser(run, neventsmax)
   

    def PlotFFT(dataind):
        
        fig2 = figure(2, figsize=(10, 8))                
       
        ax1= fig2.add_subplot(311)
        ax2 = fig2.add_subplot(312)
        ax3 = fig2.add_subplot(313)
        
        ax1.cla()
        ax2.cla()
        ax3.cla()
        
        ax1.grid()
        ax2.grid()
        ax3.grid()
        
        x_drs = np.arange(0, 300, 1)
        data = eb.event['data']
        drsdata = data[pixelID] 
        ft = fft(drsdata)
        ax1.plot(x_drs, data[0])
        
        ax2.plot(x_drs, ft)
        
        invdata = ifft(ft)
        
        ax3.plot(x_drs, invdata)
        ax3.set_xlabel("DRS counts")

        

        fig2.canvas.draw()
        
         
    eb.userfunc = PlotFFT
    
    show()
   

    
      
  
      
