#ifndef CSV_H
#define CSV_H


// SYSTEM INCLUDES
//

// PROJECT INCLUDES
#include <TROOT.h>
#include <TH1F.h>
#include <TString.h>
//

// LOCAL INCLUDES
#include "pulse.h"
#include "pixel.h"
#include "pixelsum.h"
//

// FORWARD REFERENCES
//

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/**
*/

class Csv
{
public:

// LIFECYCLE

    /** Default constructor.
    */
    Csv(TString path, TString fileName);
    Csv(TString path, TString fileName, int verbLevel);
    Csv(TString path, TString fileName, TString suffix, int verbLevel);


    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */
    /** Destructor.
    */
    ~Csv();


// OPERATORS

    /** Assignment operator.
    *
    * @param from THe value to assign to this object.
    *
    * @return A reference to this object.
    */
//    XX&                     operator=(const XX& from);

// OPERATIONS
private:
    void BuildPath();
    void CloseCsv();
    void OpenCsv();
public:
    bool WritePixelToCsv(
            Pixel* pixel,
            TString overlayMethod,
            int order
            );
    void WritePointSet(
            Pixel*          pixel,
            TString         overlayMethod,
            int             order
            );
    void WritePulseAttributes(
            Pixel*          pixel,
            Pulse*          pulse,
            TString         overlayMethod
            );
    void WritePointSetExplain();

// ACCESS
public:
    void GetFilename();
    void GetPath();


// INQUIRY
private:
    TString     mDirectory;
    TString     mFilename;
    TString     mSuffix;
    TString     mPath;
    ofstream    mCsvFile;
    int         mVerbLevel;
};

#endif // CSV_H
