#ifndef Pulse_H
#define Pulse_H

// SYSTEM INCLUDES
//

// PROJECT INCLUDES
#include <TROOT.h>
#include <TMath.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TF1.h>
#include <TString.h>
#include <TSystem.h>
#include <TFitResult.h>
//

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/**
*/
// NON CLASS MATH FUNCTIONS
int     Heaviside(double val);
double  shapeFunc(   double* t, double* par);
double  shapeFunc2(  double* t, double* par);

class Pulse
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    Pulse( );
    Pulse(TString name);
    Pulse(TString name, TH1* histo );
    Pulse(TString name, TH1* histo, int type);
    Pulse(TString name, TH1* histo, TString options );
    Pulse(TString name, TH1* histo, TString options, int type);

    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */
    /** Destructor.
    */
    ~Pulse();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS
//    double shapeFunc( double* x, double* par);
    void    Fit(TString fitName, TString fitOptions, int type );
    void    Fit(TString fitName, TString fitOptions, int type, int fitMin, int fitMax);

private:
    void    FitSectionWise(TString fitName, TString fitOptions, int fitMin, int fitMax);
    void    FitContious(TString fitName, TString fitOptions, int fitMin, int fitMax);
    void    CalculateParameters();
    void    InitMembers();

// ACCESS
public:
    double  GetBsl();
    double  GetHeight();
    double  GetT0();
    double  GetT1();
    double  GetTau1();
    double  GetTau2();
    double  GetIntegral();
    double  GetAmplitude();
    int     GetPhe();
    int     GetType();
    int     GetFitMin();
    int     GetFitMax();
    double  GetFitProb();
    double  GetFitNCalls();
    double  GetFitNdf();
    double  GetChi2();

// INQUIRY
private:
    TString mName;
    TH1*    mHisto;
    TF1*    mModel;
    TString mOptions;
    double  mBsl;
    double  mHeight;
    double  mT0;
    double  mT1;
    double  mTau1;
    double  mTau2;
    double  mIntegral;
    double  mAmplitude;
    int     mPhE;
    int     mType;
    int     mFitMin;
    int     mFitMax;
    double  mFitProb;
    double  mFitNCalls;
    double  mFitNdf;
    double  mChi2;

    TFitResultPtr mFitResultPtr;
};

#endif // Pulse_H
