#ifndef SAVETOCSV_H
#define SAVETOCSV_H

//////////////////////////////////////////////////////////////
//Functions for FPulsetemplate to write template Pulse to csv
//////////////////////////////////////////////////////////////

void
WritePixelTemplateToCsv(
        TString         path,
        TString     csv_file_name,
        TString     ovoid
        FitMaxPropabilityPuls(
                TH1F*           hMaximumTemp,
                int             verbosityLevel
                );

        double
        PolExp(
                double*         x,
                double*         par
                );

        void
        FitFallingEdge(
                TString         name,
                TH1F*           histo,
                double          xMin,
                double          xMax,
                double*         parameters
                );

        double
        template_function(
                double*         input_x,
                double*         par);

        double
        NegPolExp(
                double*         x,
                double*         par
                );

        void
        FitRisingEdge(
                TString         name,
                TH1F*           histo,
                double          xMin,
                double          xMax,
                double*         parameters
                );

        double
        ChargeDiode(
                double          time,
                double          chargeVoltage,
                double          impedance,
                double          capacity
                );

        double
        UnChargeDiode(
                double*         time,
                double*         chargeVoltage,
                double*         timeConstant
                );verlay_method,
        int             pixel,
        int             verbosityLevel
        );

TString
BuildPath(
        TString         path,
        TString     csv_file_name,
        int             pixel
        );
#endif // SAVETOCSV_H
