#ifndef MARS_MSrcPosCam
#define MARS_MSrcPosCam

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MSrcPosCam : public MParContainer
{
private:
    Float_t fX; // [mm] x position of source in camera
    Float_t fY; // [mm] y position of source in camera

public:
    MSrcPosCam(const char *name=NULL, const char *title=NULL);

    void Clear(Option_t *)           { fX = 0; fY = 0; }

    void SetX(Float_t x)             { fX = x; }
    void SetY(Float_t y)             { fY = y; }
    void SetXY(Float_t x, Float_t y) { fX = x; fY = y; }

    Float_t GetX() const             { return fX; }
    Float_t GetY() const             { return fY; }

    void Print(Option_t *opt=NULL) const;

    //void AsciiRead(ifstream &fin);
    //void AsciiWrite(ofstream &fout) const;

    ClassDef(MSrcPosCam, 1) // container to store source position in the camera plain
};

#endif
