#ifndef MONTECARLO_H
#define MONTECARLO_H

/**  A one line description of the class.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see something
 */


// SYSTEM INCLUDES
#include <vector>
#include <fstream>
#include <endian.h>
#include <stdio.h>

#include <TSystem.h>
#include <TString.h>
#include <TStyle.h>
#include <TCanvas.h>
#include <TMath.h>
#include <TFile.h>
#include <TH1.h>
#include <TH2F.h>
#include <TF1.h>
#include <TTree.h>
//

// PROJECT INCLUDES
#include "MStatusDisplay.h"
#include "MStatusArray.h"
#include "MParContainer.h"

#include "MParameters.h"
#include "MPedestalCam.h"
#include "MMcRunHeader.hxx"
#include "MGeomCamFACT.h"
#include "MRawRunHeader.h"
#include "MCorsikaRunHeader.h"

//Evt data types
#include "MRawEvtData.h"
#include "MPedestalCam.h"
#include "MMcEvt.hxx"
#include "MMcEvtBasic.h"
#include "MRawEvtHeader.h"
#include "MCorsikaEvtHeader.h"



//

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//

using namespace std;
using namespace TMath;

struct pixel_t
{
    int                 SoftId;
//    int                 ChId;
    unsigned short*     rawData;
    float               pedestal;
};

class MonteCarlo
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    MonteCarlo();
    MonteCarlo(TString filename);
    MonteCarlo(TString filename, TString evtsTreeName);
    MonteCarlo(TString filename, TString evtsTreeName, TString headerTreeName);


//    /** Copy constructor.
//    *
//    * @param from The value to copy to this object.
//    */
//    MonteCarlo(const MonteCarlo& from);


    /** Destructor.
    */
    ~MonteCarlo(void);


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    MonteCarlo&                     operator=(const XX& from);

// OPERATIONS
    void InitVariables();

    void WriteMc2Csv(TString filename );
    void WritePixelData2Csv(int pixelID);
    void WriteEventData2Csv();
    void WriteEventDataNames2Csv();
    void WriteEventHeaderNames2Csv();
    void WriteEventHeader2Csv();
    void WriteRunHeaderNames2Csv();
    void WriteRunHeader2Csv();
    void WriteFileHeader2Csv();


// ACCESS
    void SetVerbosityLevel(int verbLvl);
    int  GetVerbosityLevel();

    void OpenRootFile();
    void CloseRootFile();

    void OpenCsvFile(   TString fileName);
    void CloseCsvFile();

    void LoadEventTree( TString treeName);
    void LoadHeaderTree(TString treeName);

    void ReadRunHeader();
    void ReadEventRawData();
    void ReadEventMetaData();
    void ReadEvent(int Event);

// INQUIRY
private:
    int                 mVerbosityLvl;

    TString             mCsvFileName;
    ofstream            mCsv;
    TString             mFileName;
    TFile*              mpRootFile;
    pixel_t*            mpPixel;

    TTree*              mpEventTree;
    TTree*              mpHeaderTree;

    //header data types
    MParameterD*        mpIntendedPulsePos;
    MMcRunHeader*       mpMcRunHeader;
    MGeomCamFACT*       mpGeomCam;
    MRawRunHeader*      mpRawRunHeader;
    MCorsikaRunHeader*  mpCorsikaRunHeader;

    //Evt data types
    MPedestalCam*       mpElectronicNoise;
    MRawEvtData*        mpRawEventData;
    MParameterD*        mpIncidentAngle;
    MMcEvt*             mpMcEventMetaData;
    MRawEvtHeader*      mpRawEventHeader;
    MCorsikaEvtHeader*  mpCorsikaEvtHeader;

    unsigned short *    mpSamples;          // array with MC events raw data
    TString             mSeparator;

    //Run Meta Data
    int                 mNumberOfEntries;
    int                 mNumberOfEvents;
    float               mIntendedPulsePos;
    float               mPedestalOffset;
    int                 mNumSimulatedShowers;
    int                 mNumberOfPixels;
    int                 mNumberOfSectors;
    int                 mNumberOfAreas;
    float               mNumberOfSamples;
    float               mSamplingFrequency;
    int                 mNumberOfEventsRead;
    float               mCamDist;
    const char*         mSourceName;
    float               mSlopeSpectrum;
    float               mEnergyMin;
    float               mEnergyMax;
    float               mZdMin;
    float               mZdMax;
    float               mAzMin;
    float               mAzMax;
    unsigned int        mFileNumber;
    int                 mRunNumber;
    int                 mRunType;
    int                 mNumberOfBytes;

    //Event Meta Data
    float               mIncidentAngle;
    int                 mPartId;
    float               mEnergy;
    float               mImpact;
    float               mTelescopePhi;
    float               mTelescopeTheta;
    float               mPhi;
    float               mTheta;
    TString             mPartName;
    TString             mPartSymbol;
    unsigned int        mCorsikaEventNumber;
    unsigned int        mPhotElFromShower;
    unsigned int        mPhotElinCamera;
    int                 mEvtReuse;
    int                 mEventNumber;
    float               mNumTriggerLvl1;
    float               mNumTriggerLvl2;
    float               mFirstInteractionHeight;
    float               mMomentumX;
    float               mMomentumY;
    float               mMomentumZ;
    float               mZd;
    float               mAz;
    float               mX;
    float               mY;
//    int                 mWeightedNumPhotons;




protected:

};

// INLINE METHODS
//

// EXTERNAL REFERENCES
//

#endif // MONTECARLO_H

