/**
 * @fileOverview
 *    Documentation of a DIM service Subscription
 */

/**
 * @class
 *
 * Creates a handle to a new thread. The handle can be used to
 * kill the thread or be ignored. The function provided is
 * executed after an initial timeout. Note that although this
 * looks similar to the setTimeout in web-browsers, after started,
 * the thread will not run until completion but run in parallel to
 * the executed script.<P>
 *
 * Note that although the object is created with 'new' and there
 * is a 'delete' is JavaScript, it will not call any kind of
 * destructor. To close a Subscription you have to explicitly call
 * the close() member function. 'delete' in JavaScript is only
 * to remove a property from an Object.
 *
 * @param {Integer} timeout
 *    A positive integer given the initial delay in milliseconds before
 *    the thread is executed.
 *
 * @param {Function} function
 *    A function which is executed aftr the initial timeout.
 *
 * @throws
 *    <li> If number or type of arguments is wrong
 *
 * @example
 *    var handle = new Thread(100, function() { dim.out("Hello world!"); });
 *    handle.kill();
 */
function Subscription(service)
{
    /**
     *
     * The name of the service subscribed to.
     *
     * @constant
     * @type String
     *
     */
    this.name = service;

    /**
     *
     * Boolean value which is set to false if the Subscription was closed.
     *
     * @type Boolean
     *
     */
    this.isOpen = false;

    /**
     *
     * Callback in case of event reception.
     *
     * To install a callback in case a new event of this Subscription
     * was received, set this property to a function. The argument
     * provided to the function is identical with the object returned
     * by Subscription.get(). For the code executed, the same rules apply
     * than for a thread created with Thread.
     *
     * @type Function
     *
     * @example
     *     subscription.onchange = function(event) { dim.out(JSON.stringify(event); };
     *
     */
    this.onchange = func;

    /**
     *
     * Returns the last received event of this subscription.
     *
     * @param {Integer} [timeout=0]
     *     A timeout in millisecond to wait for an event to arrive.
     *     This timeout only applied if no event has been received yet
     *     after a new Subscription has been created. If an event
     *     is already available, the event is received. If the timeout
     *     is 'null', waiting will nevr timeout until an event was received.
     *     If the timeout is less than zero, no exception will be thrown,
     *     but 'undefined' returned in case of timeout. The corresponding
     *     timeout is then Math.abs(timeout).
     *
     * @param {Boolean} [requireNamed=true]
     *     Usually an event is only considered complete, if also the
     *     corresponding decription is available distcibuted through
     *     the service SERVER/SERVICE_DESC. If an event has no
     *     subscription or it is not important, requireNamed can
     *     be set to false.
     *
     * @throws
     *    <li> If number or type of arguments is wrong
     *    <li> After a timeout, if the timeout value was greater or equal zero
     *    <li> If conversion of th received data to an event object has failed
     *
     * @returns {Event}
     *     If the thread was still known, true is returned, false
     *     otherwise. If the thread terminated already, false is
     *     returned.
     *
     */
    this.get = function() { /* [native code] */ }

    /**
     *
     * Unsubscribe from an existing subscription. Note that all open
     * subscription produce network traffic and should be omitted if
     * not needed.
     *
     * @returns {Boolean}
     *     true if the subscription was still open, false if it was
     *     already closed.
     *
     */
    this.close() = function() { /* [native code] */ }
}
