#ifndef MARS_MBlindPixelCalc
#define MARS_MBlindPixelCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MBlindPixels;

class MBlindPixelCalc : public MTask
{
private:
    MCerPhotEvt  *fEvt;     //!
    MBlindPixels *fPixels;  //!
    MGeomCam     *fGeomCam; //!

    TArrayS fPixelsID;  // Pixel IDs for blind pixels, which are entered by the user.

    Bool_t fUseInterpolation;
    Bool_t fUseCentralPixel;

    void Interpolate() const;
    void Unmap() const;

public:
    MBlindPixelCalc(const char *name=NULL, const char *title=NULL);

    void SetUseInterpolation(Bool_t b=kTRUE) { fUseInterpolation=kTRUE; }
    void SetUseCetralPixel(Bool_t b=kTRUE)   { fUseCentralPixel=kTRUE; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    void SetPixels(Int_t num, Short_t *ids);
    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MBlindPixelCalc, 0) // task to disable given pixels for analysis
}; 

#endif

