#ifndef MARS_MCameraSmooth
#define MARS_MCameraSmooth

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MBlindPixels;

class MCameraSmooth : public MTask
{
private:
    MCerPhotEvt *fEvt;     //!
    MGeomCam    *fGeomCam; //!

    Byte_t fCounts;
    Bool_t fUseCentralPixel;

public:
    MCameraSmooth(Byte_t cnt=1, const char *name=NULL, const char *title=NULL);

    void SetUseCetralPixel(Bool_t b=kTRUE) { fUseCentralPixel=kTRUE; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCameraSmooth, 0) // task to smooth the camera contants
}; 

#endif

