#include "Sample.h"

Sample::Sample()
{
    InitMembers();
    mpRndNumList = new vector<int>;
}

Sample::Sample(int size)
{
    InitMembers();
    mpRndNumList = new vector<int>;
    mpRndNumList->resize(size);
}

Sample::Sample(vector<int> *RndNumList)
{
    InitMembers();
    mpRndNumList    =   RndNumList;
}

Sample::Sample(vector<int> *RndNumList, int size)
{
    InitMembers();
    mpRndNumList    =   RndNumList;
    mpRndNumList->resize(size);
}

Sample::~Sample(void)
{
    if (mpRndNumList != NULL)
    {
        delete mpRndNumList;
    }
}

void Sample::InitMembers()
{
    mpRndNumList    = NULL;
    mMinNumber      = 0;
    mMaxNumber      = 0;
    mSampleSize     = 0;
    mSeed           = 4357;
}

//============================================================================
//ACCESS
//============================================================================
void    Sample::SetMinNumber(int min){  mMinNumber  = min; return;}
void    Sample::SetMaxNumber(int max){  mMaxNumber  = max; return;}
void    Sample::SetSampleSize(int size){mSampleSize = size; return;}
void    Sample::SetSeed(int seed)
{
    mSeed = seed;
    mRandom.SetSeed(mSeed);
    return;
}
int     Sample::GetMinNumber(){return   mMinNumber;}
int     Sample::GetMaxNumber(){return   mMaxNumber;}
int     Sample::GetSampleSize(){return  mSampleSize;}
int     Sample::GetSeed(){return  mSeed;}

void    Sample::GetRndListValues(vector<int> *RndNumList)
{
    vector<int>::iterator it;

    for ( it=mpRndNumList->begin() ; it < mpRndNumList->end(); it++ )
    {
        RndNumList->push_back(*it);
    }

    return;
}

vector<int>*    Sample::GetRndListPtr()
{
    return mpRndNumList;
}

//============================================================================
//OPERATIONS
//============================================================================
int
Sample::GenerateRandomInt(
        int     min,
        int     max)
{
    int rndNum = min + mRandom.Integer(max - min);
    cout << rndNum << endl;
    return rndNum;
}

int
Sample::GenerateRandomInt()
{
    return GenerateRandomInt( mMinNumber, mMaxNumber );
//    return 0;
}

void
Sample::GenerateSample()
{
    GenerateSample( mpRndNumList, mMinNumber, mMaxNumber, mSampleSize);
    return;
}

void
Sample::GenerateSample(
        vector<int>*    sampleVector,
        int     min,
        int     max,
        int     size)
{
    if ( size > max - min)
    {
        cout << "sample size is larger than range of sample, will set size to range" << endl;
        size = max - min + 1;
    }
    //resize destination vector for pulled numbers
    sampleVector->resize(size);

    //calculate qunatity of numbers in range
    int qunatityOfNumbers = max - min + 1;

    //crate a vector list of ordered numbers in defined range
    vector<int> listOfNumbers;
    listOfNumbers.resize(qunatityOfNumbers);

    //fill a list of ordered numbers in defined range
    for (int i = min; i <= max; i++)
    {
            listOfNumbers.at(i)=i;
    }

    //container to fill in numbers with ordering
    set<int> sampleSet;

    //container for insert result
    bool result;
    for (int i = 0; i < size; i++)
    {
        int randomNumber = GenerateRandomInt( 0, qunatityOfNumbers-i);
        result = sampleSet.insert(listOfNumbers.at(randomNumber)).second;
        if (result)
        {
//        cout << "rndNR " << randomNumber << endl;
            listOfNumbers.erase(listOfNumbers.begin()+randomNumber);
        }
        else if (!result)
        {
            cout << " pulled number exists, pulling again" << endl;
            i--;
        }
    }

    set<int>::iterator it;

    int counter = 0;
    for ( it=sampleSet.begin() ; it != sampleSet.end(); it++ )
    {
        sampleVector->at(counter)=*it;
        counter++;
    }

     return;
}

void
Sample::BootstrapSample()
{
    BootstrapSample( mpRndNumList, mMinNumber, mMaxNumber, mSampleSize );

    return;
}

void
Sample::BootstrapSample(
        vector<int> *sampleVector,
        int   numMinEvent,
        int   numMaxEvent,
        int   size)
{
    sampleVector->resize(size);

    multiset<int> sampleSet;

    for (int i = 0; i < size; i++)
    {
        int randomNumber = GenerateRandomInt( numMinEvent, numMaxEvent);
        sampleSet.insert(randomNumber);
    }

    multiset<int>::iterator it;

//    set<int>::iterator it;

    int counter = 0;
    for ( it=sampleSet.begin() ; it != sampleSet.end(); it++ )
    {
        sampleVector->at(counter)=*it;
        counter++;
    }

    return;
}
