/*
  Ideas for random sampling:

  Bootstrapping: pull with pu back
  generate a random list of Eventnumbers, induvidual number can occure certain
  times in list, put numbers in List sorted.
  read eventnumbers to process from list
  USE: STL multiset

  sampling: pull random evtn numbers without putting back
  generate a random list with subset of eventlist. pull random number and put
  it in list sorted. if number occurs again skip it. and try next number
  USE: STL set
  */

#ifndef SAMPLE_H
#define SAMPLE_H

/**  A one line description of the class.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see something
 */


// SYSTEM INCLUDES
#include <iostream>
#include <vector>
#include <set>
#include <utility>
//

// PROJECT INCLUDES
#include <TRandom3.h>
//

//Evt data types
//

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//
using namespace std;

class Sample
{
public:
    // LIFECYCLE

        /** Default constructor.
        */
    Sample();
    Sample(int size);
    Sample(vector<int> *RndNumList);
    Sample(vector<int> *RndNumList, int size);

    ~Sample(void);
    // OPERATORS

    //    /** Assignment operator.
    //    *
    //    * @param from THe value to assign to this object.
    //    *
    //    * @return A reference to this object.
    //    */
    //    MonteCarlo&                     operator=(const XX& from);

    // OPERATIONS
    void InitMembers();

    int     GenerateRandomInt();
    int     GenerateRandomInt(int min, int max);
    void    GenerateSample();
    void    GenerateSample(vector<int>* sampleVector, int min, int max, int size);
    void    BootstrapSample();
    void    BootstrapSample(vector<int>* sampleVector, int min, int max, int size);


    // ACCESS
    void    SetMinNumber(int min);
    void    SetMaxNumber(int max);
    void    SetSampleSize(int size);
    void    SetSeed(int seed);
    int     GetMinNumber();
    int     GetMaxNumber();
    int     GetSampleSize();
    int     GetSeed();
    void    GetRndListValues(vector<int> *RndNumList);
    vector<int>*    GetRndListPtr();

    // INQUIRY
private:
    vector<int>*    mpRndNumList;
    int             mMinNumber;
    int             mMaxNumber;
    int             mSampleSize;
    int             mSeed;
    TRandom3        mRandom;

};

// INLINE METHODS
//

// EXTERNAL REFERENCES
//

#endif // SAMPLE_H

