#ifndef TEMPLATEEXTRACTORS_H
#define TEMPLATEEXTRACTORS_H

#include <TROOT.h>
#include <TMath.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TF1.h>
#include <TString.h>
#include <TSystem.h>

#include "pixel.h"
#include "Sample.h"

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/** CalcMaxPropabilityOfSlice(
        TH2*            inputHisto,
        TH1*            outputHisto,
        int             verbosityLevel
        );
* Generates a Y-Projection for each slice of a TH2 histogram
* Then calls the Value of the bin with Maximum Value and puts it
* into the corresponding bin of a TH1 histogram
* @see Event::CalibrateAllPixel()
* @see Event::CalculatePhotonCharge()
*/
void
CalcMaxPropabilityOfSlice(
        TH2*            inputHisto,
        TH1*            outputHisto,
        int             verbosityLevel
        );

void
PlotMaxPropabilityPulse(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

void
FitMaxPropabilityPulse(
        TH1F*           inputHisto,
        int             verbosityLevel
        );

Double_t MedianOfH1 (
        TH1*            inputHisto
        );

Double_t MedianOfH1withRndSlices (
        TH1*            inputHisto,     //histogram from which median will be calculated
        vector<int> *position        //array with random slice numbers
        );

void
PlotMedianOfSlice(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

void
PlotMeanOfSlice(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

void
MedianOfTH2Slices(
        TH2*        inputHisto,
        TH1*        outputHisto,
        int         verbosityLevel
        );

void
ErrorMedianOfTH2Slices(
        TH2*        inputHisto,
        TH1*        outputHisto,
        int         numIterations,
        int         verbosityLevel
        );

void
ExtractPulseTemplate(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             order,
        int             verbosityLevel
        );

bool
WritePixelTemplateToCsv(
        Pixel*          CurrentPixel,
        TString         path,
        TString         overlayMethod,
        int             order,
        int             verbosityLevel
        );

//void
//FitMaxPropabilityPuls(
//        TH1F*           hMaximumTemp,
//        int             verbosityLevel
//        );

//double
//PolExp(
//        double*         x,
//        double*         par
//        );

//void
//FitFallingEdge(
//        TString         name,
//        TH1F*           histo,
//        double          xMin,
//        double          xMax,
//        double*         parameters
//        );

//double
//template_function(
//        double*         input_x,
//        double*         par);

//double
//NegPolExp(
//        double*         x,
//        double*         par
//        );

//void
//FitRisingEdge(
//        TString         name,
//        TH1F*           histo,
//        double          xMin,
//        double          xMax,
//        double*         parameters
//        );

//double
//ChargeDiode(
//        double          time,
//        double          chargeVoltage,
//        double          impedance,
//        double          capacity
//        );

//double
//UnChargeDiode(
//        double*         time,
//        double*         chargeVoltage,
//        double*         timeConstant
//        );

#endif // TEMPLATEEXTRACTORS_H

