#ifndef MARS_MFillH
#define MARS_MFillH

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MH;
class MParList;

class MFillH : public MTask
{
private:
    const MParContainer *fParContainer;
    TString fParContainerName;

    MH* fH;
    TString fHName;

    TString ExtractName(const char *name) const;
    TString ExtractClass(const char *name) const;

    void Init(const char *name, const char *title);

public:
    MFillH(const char *hist, const char *par=NULL,     const char *name=NULL, const char *title=NULL);
    MFillH(const char *hist, const MParContainer *par, const char *name=NULL, const char *title=NULL);
    MFillH(MH *hist,         const char *par=NULL,     const char *name=NULL, const char *title=NULL);
    MFillH(MH *hist,         const MParContainer *par, const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void SavePrimitive(ofstream &out, Option_t *o="");

    ClassDef(MFillH, 0) // Task to fill a histogram with data from a parameter container
};
    
#endif

