#ifndef MARS_MEvtLoop
#define MARS_MEvtLoop

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MEvtLoop                                                                //
//                                                                         //
// Class to execute the tasks in a tasklist                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MParList;
class MTaskList;
class TGProgressBar;

class MEvtLoop : public MParContainer
{
private:
    MParList  *fParList;
    MTaskList *fTaskList;      //!

    TGProgressBar *fProgress;  //!

    enum { kIsOwner = BIT(14) };

public:
    MEvtLoop();
    virtual ~MEvtLoop();

    void       SetParList(MParList *p)  { fParList = p; }
    MParList  *GetParList() const       { return fParList; }
    MTaskList *GetTaskList() const      { return fTaskList; }

    void SetOwner(Bool_t enable=kTRUE);

    void SetProgressBar(TGProgressBar *bar) { fProgress = bar; }

    Bool_t PreProcess(const char *tlist="MTaskList");
    void   Process(Int_t maxcnt) const;
    Bool_t PostProcess() const;

    Bool_t Eventloop(Int_t maxcnt=-1, const char *tlist="MTaskList");

    void SavePrimitive(ofstream &out, Option_t *o="");

    ClassDef(MEvtLoop, 1) // Class to execute the tasks in a tasklist
};

#endif
