//--------------------------------------------------------------------------------
//
//
//
#include <iostream>
#include <string>
#include <stdlib.h>

#include <TROOT.h>
#include <TSystem.h>
#include <TString.h>
#include <TStyle.h>

//#include <stdio.h>

#include "MonteCarlo.h"

using namespace std;

    int mmc2csv(
            TString     rootFile        = "",
            TString     csvDestination  = "",
            int         verbLvl         = 0
            )
    {

        cout << "...loading MC file" << endl;
        TString temp = rootFile;
    //    if (!gSystem->BaseName(csvFile)){
    //        TString csvFile = gSystem->DirName(csvLocation);

            temp = temp.Remove(
                        rootFile.Last('.'),
                        rootFile.Length() - rootFile.Last('.')
                        );
    //        csvDestination += "/";
            csvDestination += gSystem->BaseName(temp);
            csvDestination += ".csv";
    //       }

    //    cout << csvDestination << endl ;

        MonteCarlo MC( rootFile );

        cout << "...setting verbosity Level" << endl;
        MC.SetVerbosityLevel(verbLvl);

        cout << "...converting mc to csv" << endl;
        MC.WriteMc2Csv(csvDestination);

    return 0;

    }

int main(int argc, char* argv[])
{
    int verbLVL = 0;
        std::string arg;
        std::string inFile, outPath;
        // Check the number of parameters
        if (argc < 2) {
                // Tell the user how to run the program
                std::cerr << "Usage: " << argv[0]
                          << " -i <infile> -o <outdir> -vvvv \n"
                          << std::endl;
                /* "Usage messages" are a conventional way of telling the user
                 * how to run a program if they enter the command incorrectly.
                 */
                return 1;
        }

        for ( int i = 0; i < argc; i++)
        {
            if (i < argc) // Check that we haven't finished parsing already
            {
                arg = argv[i];

                if (arg == "-i" || arg == "--input" )
                {
                    inFile = argv[i+1];
                    std::cout << "inFile: " << inFile << std::endl;
                }
                else if (arg == "-o" || arg == "--output" )
                {
                    outPath = argv[i+1];
                    std::cout << "outPath: " << outPath << std::endl;
                }
                else if ( arg.find_first_of("-") == 0 && arg.find_first_of("v") == 1 ){
                    verbLVL = arg.find_last_of("v") - arg.find_first_of("v") + 1;
                    std::cout << "verbosity level: " << verbLVL << std::endl;
                }
            }
            else
            {
                std::cout << "Not enough or invalid arguments, please try again.\n";
                exit(0);
            }
        }

        //        mmc2csv(myFile, myOutPath, verbLvl);
        cout << "mmc2csv(" << inFile << ", " << outPath << ", "
             << verbLVL << " )" << endl;
        return 0;
}

