#ifndef MARS_MParContainer
#define MARS_MParContainer

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// MParContainer                                                        //
//                                                                      //
// The basis for all parameter containers                               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef ROOT_TObject
#include <TObject.h>
#endif
#ifndef ROOT_TString
#include <TString.h>
#endif

class ofstream;
class ifstream;

class TDataMember;
class TMethodCall;

class MParContainer : public TObject
{
protected:
    TString fName;        // parameter container identifier (name)
    TString fTitle;       // parameter container title

    MLog   *fLog;         // The general log facility for this object, initialized with the global object

private:
    Bool_t  fReadyToSave; // should be set to true if the contents of the container is changed somehow

public:
    MParContainer(const char *name="", const char *title="") : fName(name), fTitle(title), fLog(&gLog), fReadyToSave(kFALSE) {  }
    MParContainer(const TString &name, const TString &title) : fName(name), fTitle(title), fLog(&gLog), fReadyToSave(kFALSE) {  }
    MParContainer(const MParContainer &named);
    MParContainer& operator=(const MParContainer& rhs);
    virtual ~MParContainer() {}

    virtual TObject    *Clone(const char *newname="") const;
    virtual Int_t       Compare(const TObject *obj) const;
    virtual void        Copy(TObject &named);
    virtual void        FillBuffer(char *&buffer);

    virtual const char *GetDescriptor() const { return Form("%s [%s]", fName.Data(), ClassName()); }
    virtual const char *GetName() const       { return fName.Data(); }
    virtual const char *GetTitle() const      { return fTitle.Data(); }
    virtual ULong_t     Hash() const          { return fName.Hash(); }
    virtual Bool_t      IsSortable() const    { return kTRUE; }

    virtual void        SetName(const char *name); // *MENU*
    virtual void        SetObject(const char *name, const char *title);
    virtual void        SetTitle(const char *title=""); // *MENU*
    virtual void        ls(Option_t *option="") const;
    virtual void        Print(Option_t *option="") const;
    virtual Int_t       Sizeof() const;
    virtual void        SavePrimitive(ofstream &out, Option_t *o="");

    virtual void   SetLogStream(MLog *lg) { fLog = lg; }
    virtual void   Reset() { }
    virtual Bool_t IsReadyToSave() const             { return fReadyToSave; }
    virtual void   SetReadyToSave(Bool_t flag=kTRUE) { fReadyToSave=flag; }

    TMethodCall *GetterMethod(const char *name) const;

    Bool_t WriteDataMember(ostream &out, const char *member, Double_t scale=1) const;
    Bool_t WriteDataMember(ostream &out, const TDataMember *member, Double_t scale=1) const;
    Bool_t WriteDataMember(ostream &out, const TList *list) const;

    virtual void AsciiRead(ifstream &fin);
    virtual Bool_t AsciiWrite(ostream &out) const;

    virtual void GetNames(TObjArray &arr) const;
    virtual void SetNames(TObjArray &arr);

    ClassDef(MParContainer, 0)  //The basis for all parameter containers
};

/*
class MParContainer : public TNamed
{
protected:
    MLog    *fLog;         //! The general log facility for this object, initialized with the global object

private:
    Bool_t   fReadyToSave; //! should be set to true if the contents of the container is changed somehow

public:
    MParContainer(const char *name="", const char *title="") : TNamed(name, title), fLog(&gLog), fReadyToSave(kFALSE) { }
    MParContainer(const TString &name, const TString &title) : TNamed(name, title), fLog(&gLog), fReadyToSave(kFALSE) { }

    void SetLogStream(MLog *lg)                      { fLog = lg; }

    virtual void   Reset()                           {  }

    virtual Bool_t IsReadyToSave()                   { return fReadyToSave; }
    virtual void   SetReadyToSave(Bool_t flag=kTRUE) { fReadyToSave=flag; }

    virtual void AsciiRead(ifstream &fin);
    virtual void AsciiWrite(ofstream &fout) const;

    ClassDef(MParContainer, 0)  //The basis for all parameter containers
};
*/
#endif


