#ifndef MARS_MBinning
#define MARS_MBinning

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include "TArrayD.h"
#endif

class TH1;

class MBinning : public MParContainer
{
private:
    TArrayD fEdges;

public:
    MBinning(const char *name=NULL, const char *title=NULL);

    void SetEdges(const TArrayD &arr)
    {
        fEdges = arr;
    }

    void SetEdges(const Int_t nbins, const Axis_t lo, Axis_t up)
    {
        const Double_t binsize = (up-lo)/nbins;
        fEdges.Set(nbins+1);
        for (int i=0; i<=nbins; i++)
            fEdges[i] = binsize*i + lo;
    }

    void SetEdgesLog(const Int_t nbins, const Axis_t lo, Axis_t up)
    {
        // if (lo==0) ...

        const Double_t binsize = log10(up/lo)/nbins;
        fEdges.Set(nbins+1);
        for (int i=0; i<=nbins; i++)
            fEdges[i] = pow(10, binsize*i) * lo;
    }

    // FIXME: ROOT workaround: "operator[] const" missing
    Double_t GetEdgeLo() const { return (*(TArrayD*)(&fEdges))[0]; }
    Double_t GetEdgeHi() const { return (*(TArrayD*)(&fEdges))[fEdges.GetSize()-1]; }

    Int_t GetNumEdges() const { return fEdges.GetSize(); }
    Int_t GetNumBins() const { return fEdges.GetSize()-1; }

    Double_t *GetEdges() const { return fEdges.GetArray(); }

    void Apply(TH1 &);

    void SavePrimitive(ofstream &out, Option_t *o="");

    ClassDef(MBinning, 1) //Container to store the binning of a histogram
};

#endif

