#ifndef CSV_H
#define CSV_H


// SYSTEM INCLUDES
#include <iostream>
#include <fstream>
#include <stdlib.h>
//

// PROJECT INCLUDES
#include <TROOT.h>
#include <TH1F.h>
#include <TString.h>
//

// LOCAL INCLUDES
#include "pulse.h"
#include "pixel.h"
#include "pixelsum.h"
//

// FORWARD REFERENCES
//

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/**
*/

class Csv
{
public:

// LIFECYCLE

    /** Default constructor.
    */
    Csv(TString path, TString fileName);
    Csv(TString path, TString fileName, int verbLevel);
    Csv(TString path, TString fileName, TString suffix, int verbLevel);


    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */
    /** Destructor.
    */
    ~Csv();


// OPERATORS

    /** Assignment operator.
    *
    * @param from THe value to assign to this object.
    *
    * @return A reference to this object.
    */
//    XX&                     operator=(const XX& from);

// OPERATIONS
private:
    /*! \brief Built the path to the CSV file */
    void BuildPath();
    /*! \brief close the CSV file */
    void CloseCsv();
    /*! \brief open the CSV file */
    void OpenCsv();
public:
    /*! \brief Write the point set and according header of an fitted pulse to CSV
     *  calls WritePointSetHeader() and WritePointSet()
     * \param pixel Datatype Pixel, containing all pulse histograms of a Pixel
     * \param overlayMethod chosen overlaymethod
     * \param order pulse order aka quantity of photons in signal
    */
    bool WritePointSetToCsv(
            Pixel* pixel,
            TString overlayMethod,
            int order
            );
    /*! \brief Write header of the point set to CSV */
    void WritePointSetHeader();
    /*! \brief Write the point set of an fitted pulse to CSV
     * \param pixel Datatype Pixel, containing all pulse histograms of a Pixel
     * \param overlayMethod chosen overlaymethod
     * \param order pulse order aka quantity of photons in signal
    */
    void WritePointSet(
            Pixel*          pixel,
            TString         overlayMethod,
            int             order
            );
    /*! \brief Write header of the pulse parameters to CSV */
    void WritePulseAttributesHeader();
    /*! \brief Write parameters from pulse fit to CSV
     * \param pixel Datatype Pixel, containing all pulse histograms of a Pixel
     * \param pulse Datatype Pulse, containing pulse fit of a Pixel
     * \param overlayMethod chosen overlaymethod
     * \param order pulse order aka quantity of photons in signal
    */
    void WritePulseAttributes(
            Pixel*          pixel,
            Pulse*          pulse,
            TString         overlayMethod,
            int order
            );

// ACCESS
public:
    /*! \brief Get the filename of the CSV file */
    TString GetFilename();
    /*! \brief Get the path to the CSV file */
    TString GetPath();
    /*! \brief Get the verbosity Level of the CSV file */
    int GetVerbLevel(){return mVerbLevel;}
    /*! \brief Set the verbosity Level of the CSV file */
    void SetVerbLevel(int verbLevel){mVerbLevel = verbLevel;}
    /*! \brief Get the column seperator of the CSV file */
    TString GetSeparator(){return mSeparator;}
    /*! \brief Set the column seperator of the CSV file */
    void SetSeparator(TString separator){mSeparator = separator;}
    /*! \brief Get ofstream's floating-point decimal precision */
    int GetPrecision(){return mPrecision;}
    /*! \brief Set ofstream's floating-point decimal precision */
    void SetPrecision(int precision){mPrecision = precision;}

// INQUIRY
private:
    /*! directory to save csv files */
    TString     mDirectory;
    /*! csv's filename */
    TString     mFilename;
    /*! csv's filename suffix */
    TString     mSuffix;
    /*! path to the CSV file */
    TString     mPath;
    /*! csv file outstream */
    ofstream    mCsvFile;
    /*! verbosity Level */
    int         mVerbLevel;
    /*! column separator in csv file */
    TString     mSeparator;
    /*! ofstream's floating-point decimal precision */
    int         mPrecision;
};

#endif // CSV_H
