#include "Sample.h"

Sample::Sample()
{
    InitMembers();
    mpRndNumList = new vector<int>;
}

Sample::Sample(int size)
{
    InitMembers();
    mpRndNumList = new vector<int>;
    mpRndNumList->resize(size);
}

Sample::Sample(vector<int> *RndNumList)
{
    InitMembers();
    mpRndNumList    =   RndNumList;
}

Sample::Sample(vector<int> *RndNumList, int size)
{
    InitMembers();
    mpRndNumList    =   RndNumList;
    mpRndNumList->resize(size);
}

Sample::~Sample(void)
{
    if (mpRndNumList != NULL)
    {
        delete mpRndNumList;
    }
}

void Sample::InitMembers()
{
    mpRndNumList    = NULL;
    mMinNumber      = 0;
    mMaxNumber      = 0;
    mSampleSize     = 0;
    mSeed           = 4357;
}

//============================================================================
//ACCESS
//============================================================================
void    Sample::SetMinNumber(int min){  mMinNumber  = min; return;}
void    Sample::SetMaxNumber(int max){  mMaxNumber  = max; return;}
void    Sample::SetSampleSize(int size){mSampleSize = size; return;}
void    Sample::SetSeed(int seed)
{
    mSeed = seed;
    mRandom.SetSeed(mSeed);
    return;
}
int     Sample::GetMinNumber(){return   mMinNumber;}
int     Sample::GetMaxNumber(){return   mMaxNumber;}
int     Sample::GetSampleSize(){return  mSampleSize;}
int     Sample::GetSeed(){return  mSeed;}

void    Sample::GetRndListValues(vector<int> *RndNumList)
{
    vector<int>::iterator it;

    for ( it=mpRndNumList->begin() ; it < mpRndNumList->end(); it++ )
    {
        RndNumList->push_back(*it);
    }

    return;
}

vector<int>*    Sample::GetRndListPtr()
{
    return mpRndNumList;
}

//============================================================================
//OPERATIONS
//============================================================================
int
Sample::GenerateRandomInt(
        int     min,
        int     max)
{
//    int rndNum = min + mRandom.Integer(max - min);
    int rndNum = (int) mRandom.Uniform(min, max);
//    cout << rndNum << endl;
    return rndNum;
}

int
Sample::GenerateRandomInt()
{
    return GenerateRandomInt( mMinNumber, mMaxNumber );
//    return 0;
}

void
Sample::GenerateSample()
{
    GenerateSample( mpRndNumList, mMinNumber, mMaxNumber, mSampleSize);
    return;
}

void
Sample::GenerateSample(
        vector<int>*    sampleVector,
        int     min,
        int     max,
        int     size)
{
    if ( size > max - min)
    {
        cout << "sample size is larger than range of sample, will set size to range" << endl;
        size = max - min + 1;
    }
    //resize destination vector for pulled numbers
    sampleVector->resize(size);

    //calculate qunatity of numbers in range
    int qunatityOfNumbers = max - min + 1;

    //crate a vector list of ordered numbers in defined range
    vector<int> listOfNumbers;
    listOfNumbers.resize(qunatityOfNumbers);

    //fill a list of ordered numbers in defined range
    for (int i = min; i <= max; i++)
    {
            listOfNumbers.at(i)=i;
    }

    //container to fill in numbers with ordering
    set<int> sampleSet;

    //container for insert result
    bool result;
    for (int i = 0; i < size; i++)
    {
        int randomNumber = GenerateRandomInt( 0, qunatityOfNumbers-i);
        result = sampleSet.insert(listOfNumbers.at(randomNumber)).second;
        if (result)
        {
//        cout << "rndNR " << randomNumber << endl;
            listOfNumbers.erase(listOfNumbers.begin()+randomNumber);
        }
        else if (!result)
        {
            cout << " pulled number exists, pulling again" << endl;
            i--;
        }
    }

    set<int>::iterator it;

    int counter = 0;
    for ( it=sampleSet.begin() ; it != sampleSet.end(); it++ )
    {
        sampleVector->at(counter)=*it;
        counter++;
    }

     return;
}


int
Sample::BootstrapVector(vector<double> *inVector, vector<double> *outVector)
{
    //get size of sample to be bootstrapped
    int sampleSize = inVector->size();

    //Vector with positions in original sample
    vector<int> entryID (sampleSize,0);

    //calculate wich entries from inVector will be put into outVector
    BootstrapSample(&entryID, 0, sampleSize, sampleSize );

    vector<int>::iterator it;

    //Loop over entryID vector to fill content from inVector to outVector
    int counter = 0;
    for ( it=entryID.begin() ; it != entryID.end(); it++ )
    {
        outVector->at(counter) = inVector->at(*it);
        counter++;
    }

    return counter + 1;
}

int
Sample::BootstrapTH1(TH1* inputHisto, TH1*  outHisto)
{
    //compute the median for 1-d histogram h1
    int nbins = inputHisto->GetXaxis()->GetNbins();

    //we need to get the binning

    //entries of TH1
    vector<float>    entries;

    //quantity of entries in bin
    int quantity    = 0;
    float value       = 0;
    for (int i=0;i<nbins;i++)
    {
        value       = inputHisto->GetBinLowEdge(i);
        quantity    = inputHisto->GetBinContent(i);
//        cout << value << "(" << quantity << ") ";
        for (int j = 0; j < quantity; j++)
        {
            entries.push_back(value);
        }
    }

    //get size of sample to be bootstrapped
    int sampleSize = entries.size();

    //Vector with positions in original sample
    vector<int> entryID (sampleSize,0);

    //calculate a list with random EntryIDs and fill it into entryID
    BootstrapSample(&entryID, 0, sampleSize, sampleSize );

    //Loop over entryID vector to bootstrap the histogram
    int counter = 0;
    for ( unsigned int i = 0 ; i < entryID.size(); i++ )
    {
        outHisto->Fill(
                    entries.at( entryID.at(i) )
                    );
        counter++;
    }

    return counter + 1;
}

void
Sample::BootstrapSample()
{
    BootstrapSample( mpRndNumList, mMinNumber, mMaxNumber, mSampleSize );

    return;
}

void
Sample::BootstrapSample(
        vector<int> *sampleVector,
        int   numMinEvent,
        int   numMaxEvent,
        int   size)
{
    if (size == 0){
        cout << "Bootstrapping: size of vector = 0; nothing to do" << endl;
        return;
    }

    //resize the sample vector to size of boostrapped sample
    sampleVector->resize(size);

    //list of rndnumbers pulled with putting back
    multiset<int> sampleSet;

    //loop over samplesize to generate random numbers to fill into sampleset
    for (int i = 0; i < size; i++)
    {
        int randomNumber = GenerateRandomInt( numMinEvent, numMaxEvent);
        sampleSet.insert(randomNumber);
    }

    multiset<int>::iterator it;

//    set<int>::iterator it;

    int counter = 0;
    // loop over list of rndnumbers and fill their entries into sampleVector
    // entries are vector positions
    for ( it=sampleSet.begin() ; it != sampleSet.end(); it++ )
    {
        sampleVector->at(counter)=*it;
        counter++;
    }

    return;
}
//NOTE: crashes for some reason if size is smaller than max-min
