#ifndef Pulse_H
#define Pulse_H

// SYSTEM INCLUDES
#include <utility>
//

// PROJECT INCLUDES
#include <TROOT.h>
#include <TMath.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TF1.h>
#include <TString.h>
#include <TSystem.h>
#include <TFitResult.h>
//

// LOCAL INCLUDES
#include <parameter.h>
//

// FORWARD REFERENCES
//

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/**
*/
// NON CLASS MATH FUNCTIONS
int     Heaviside(double val);
double  shapeFunc(   double* t, double* par);
double  shapeFunc2(  double* t, double* par);

class Pulse
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    Pulse( );
    Pulse(TString name);
    Pulse(TString name, TH1* histo );
    Pulse(TString name, TH1* histo, int type);
    Pulse(TString name, TH1* histo, TString options );
    Pulse(TString name, TH1* histo, TString options, int type);

    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */
    /** Destructor.
    */
    ~Pulse();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS
//    double shapeFunc( double* x, double* par);
    void    Fit(TString fitName, TString fitOptions, int type );
    void    Fit(TString fitName, TString fitOptions, int type, int fitMin, int fitMax);

private:
    void    FitSectionWise(TString fitName, TString fitOptions, int fitMin, int fitMax);
    void    FitContious(TString fitName, TString fitOptions, int fitMin, int fitMax);
    void    CalculateParameters();
    double  CalculateHistEdgeRisetime();
    void    InitMembers();

// ACCESS
public:
    TString GetName();
    double  GetBsl();
    double  GetBslErr();
    double  GetHeight();
    double  GetHeightErr();
    double  GetT0();
    double  GetT0Err();
    double  GetT1();
    double  GetT1Err();
    double  GetTau1();
    double  GetTau1Err();
    double  GetTau2();
    double  GetTau2Err();
    double  GetIntegral();
    double  GetIntegralErr();
    double  GetAmplitude();
    double  GetAmplitudeErr();
    int     GetPhE();
    int     GetPhEErr();
    int     GetOrder();
    int     GetType();
    int     GetFitMin();
    int     GetFitMax();
    double  GetFitProb();
    double  GetFitNCalls();
    double  GetFitNdf();
    double  GetChi2();
    double  GetRiseTime();
    double  GetRiseTimeErr();
    double  GetTimeResolution();
    void    SetTimeResolution(double timeResolution);

// INQUIRY
private:
    TString                 mName;
    TH1*                    mHisto;
    TF1*                    mModel;
    TString                 mOptions;
    pair <double, double>   mBsl;
    pair <double, double>   mHeight;
    pair <double, double>   mT0;
    pair <double, double>   mT1;
    pair <double, double>   mTau1;
    pair <double, double>   mTau2;
    pair <double, double>   mIntegral;
    pair <double, double>   mAmplitude;
    pair <int, double>      mPhE;
    pair <double, double>   mRisetime;
    double                  mTimeResolution; // [ns/slice]
    int                     mOrder;
    int                     mType;
    int                     mFitMin;
    int                     mFitMax;
    double                  mFitProb;
    double                  mFitNCalls;
    double                  mFitNdf;
    double                  mChi2;

    TFitResultPtr           mFitResultPtr;
};

#endif // Pulse_H
