'use strict';

/* **************
 * this file contains just the implementation of the 
 * Observation class (I know there are no classes in javascript...)
 */

// Constructor
function Observation ( oArg ) {
    
    if (oArg['date'])
    {
        // FIXME: Check transisiton from summer- and winter-time!!
        var utc = new Date(oArg.date);
        if (isNaN(utc.valueOf()))
        {
            throw new Error(startDateString+' is not a valid Date String.'+
                        ' Try something like "2013-01-08 23:05 UTC" .');
        }
        this.utc = utc
    }
    else
    {
        throw new Error("Observation object must have a 'date' parameter");
    }
    
    if (oArg['task'])
        this.task = oArg.task.toUpperCase()
    else
        this.task = 'DATA'
        
    if (oArg['source'])
        this.source = oArg.source
    else
        this.source = undefined
        
    if (oArg['ra'])
        this.ra = oArg.ra
    else
        this.ra = undefined
        
    if (oArg['dec'])
        this.dec = oArg.dec
    else
        this.dec = undefined
    
    
    
    switch( this.task)
    {
        case 'DATA':
            if (this.source == undefined)
                throw new Error(
                    "Observation must have either 'source' or 'task' " +
                    "if 'task' == 'data' it must have also have 'source' ");
            break;
        case 'STARTUP':
            if ( this.source != undefined)
            {
                console.out("warning. Observation with task='startup' also has source defined");
            }
            break;
        case 'SHUTDOWN':
            if ( this.source != undefined)
            {
                console.out("warning. Observation with task='shutdown' also has source defined");
            }
            break;
        case 'RATESCAN':
            if ( this.source == undefined && (this.ra == undefined || this.dec == undefined) )
            {
                throw new Error(
                    "Observation must have either 'source' or 'ra' & 'dec' " +
                    "if 'task' == 'ratescan'");
            }
    }
    
    
}

// method toString()
Observation.prototype.toString = function() 
{ 
    return this.source+" ["+this.utc+"]" ;
}
