#ifndef MARS_MHillasSrcCalc
#define MARS_MHillasSrcCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHillas;
class MHillasSrc;
class MSrcPosCam;

class MHillasSrcCalc : public MTask
{
private:
    MHillas    *fHillas;     // Pointer to the source independant hillas parameters
    MSrcPosCam *fSrcPos;     // Pointer to the source position
    MHillasSrc *fHillasSrc;  // Pointer to the output container for the source dependant parameters

    TString     fSrcName;
    TString     fHillasName;

    void StreamPrimitive(ofstream &out) const;

public:
    MHillasSrcCalc(const char *src="MSrcPosCam", const char *hil="MHillasSrc",
                   const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();

    ClassDef(MHillasSrcCalc, 1) // task to calculate the source position depandant hillas parameters
};

#endif
