/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz    12/2000 <mailto:tbretz@uni-sw.gwdg.de>
!   Author(s): Rudolf Bock     10/2001 <mailto:Rudolf.Bock@cern.ch>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//
// MSrcPosCam
//
// Storage Container to hold the current position of the source (or
// anti/false source) in the camera plain
//
//////////////////////////////////////////////////////////////////////////////
#include "MSrcPosCam.h"

#include <fstream.h>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MSrcPosCam);

// --------------------------------------------------------------------------
//
// Default constructor.
//
MSrcPosCam::MSrcPosCam(const char *name, const char *title) : fX(0), fY(0)
{
    fName  = name  ? name  : "MSrcPosCam";
    fTitle = title ? title : "Source position in the camera";
}

// -----------------------------------------------------------------------
//
void MSrcPosCam::Print(Option_t *) const
{
    *fLog << all;
    *fLog << "Source position in the camera plain (" << GetName() << ")" << endl;
    *fLog << " - x [mm] = " << fX << endl;
    *fLog << " - y [mm] = " << fY << endl;
}

/*
// -----------------------------------------------------------------------
//
// overloaded MParContainer to read MSrcPosCam from an ascii file
//
void MSrcPosCam::AsciiRead(ifstream &fin)
{
    fin >> fX;
    fin >> fY;
}

// -----------------------------------------------------------------------
//
// overloaded MParContainer to write MSrcPosCam to an ascii file
//
void MSrcPosCam::AsciiWrite(ofstream &fout) const
{
    fout << fX << " " << fY;
}
*/

// --------------------------------------------------------------------------
//
// Implementation of SavePrimitive. Used to write the call to a constructor
// to a macro. In the original root implementation it is used to write
// gui elements to a macro-file.
//
void MSrcPosCam::StreamPrimitive(ofstream &out) const
{
    out << "   MSrcPosCam " << ToLower(fName) << "(\"";
    out << fName << "\", \"" << fTitle << "\");" << endl;

    out << "   " << ToLower(fName) << ".SetXY(" << fX << ", " << fY << ");" << endl;}
