#ifndef MARS_MFillH
#define MARS_MFillH

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MH;
class MParList;

class MFillH : public MTask
{
private:
    MParContainer *fParContainer;
    TString fParContainerName;

    MH* fH;                   
    TString fHName;

    TString ExtractName(const char *name) const;
    TString ExtractClass(const char *name) const;

    void Init(const char *name, const char *title);

    void StreamPrimitive(ofstream &out) const;

public:
    MFillH();
    MFillH(const char *hist, const char *par=NULL, const char *name=NULL, const char *title=NULL);
    MFillH(const char *hist, MParContainer *par,   const char *name=NULL, const char *title=NULL);
    MFillH(MH *hist,         const char *par=NULL, const char *name=NULL, const char *title=NULL);
    MFillH(MH *hist,         MParContainer *par,   const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MFillH, 1) // Task to fill a histogram with data from a parameter container
};
    
#endif

