#!/usr/bin/python -itt

import struct
import sys
import numpy as np
from pprint import pprint
import rlcompleter
import readline
readline.parse_and_bind('tab: complete')


"""
drehmatrix:

1 0 0   also in x-richtung wird gedreht mit phi=90 in  0 1 0

matrix: 
 0 0 0  1    0
 1 0 0  0 =  1 
 0 0 0  0    0
 
also 
 cos-p  0    0
 sin-p  0    0
 0      0    0
 
0 1 0 also y-richtung wird weiter gedreht in -1 0 0

  0  -1  0
  0   0  0
  0   0  0
  
also:
 cos-p  -sin-p 0     0  -1  0
 sin-p   cos-p 0 --> 1   0  0
 0       0     0     0   0  0
 
damit wird gedreht: 1 0 0 -> 0 1 0 -> -1 0 0 -> 0 -1 0 -> 1 0 0

nun mit theta = 90  damit wird 0 0 1 zu 1 0 0

also: 
 0 0 1
 0 0 0
 0 0 0

weiter 1 0 0 --> 0 0 -1

also:
 0 0 1
 0 0 0
-1 0 0

und damit klappt auch 0 0 -1 auf -1 0 0 und weiter auf 0 0 1

das waere jetzt also
 cos-p cos-t  -sin-p   sin-t
 sin-p         cos-p   ?
 -sin-t        ?       cos-t


wenn theta = 90 muss auch mit dem einheitsvector in y das richtig passieren
nämlich
0 1 0 --> 0 0 -1 --> 

"""
class Turn( object ):
    
    def __init__(self, theta, phi):
        self.last_result = None
        
        theta = -theta/180.*np.pi
        phi = -phi/180.*np.pi
        
        c = np.cos
        s = np.sin
        self.phi = phi
        self.theta = theta
        p = phi
        t = theta
        
        drehmatrix = np.zeros( (3,3) )
        self.r =  drehmatrix
        r = self.r
        
        r[0,0] = c(p)*c(t);   r[1,0] = -s(p);    r[2,0] = s(t)
        r[0,1] = s(p);        r[1,1] =  c(p);    r[2,1] = 0
        r[0,2] = -s(t);       r[1,2] = 0;        r[2,2] = c(t)
        
        print r
        

    def __call__( self, vector=None):
        
        if vector is None and not self.last_result is None:
            vector = self.last_result
        elif vector is None:
            raise ValueError("no argument given")
        turned_vector = vector.copy()
        t = turned_vector
        
        for i in range(3):
            t[i] = (self.r[i,:] * vector).sum()
        
        
        
        
        self.last_result = turned_vector
        return turned_vector
        

class Turner( object ):
    def __init__(self, theta, phi):
        self.last_result = None
        
        theta = -theta/180.*np.pi
        phi = -phi/180.*np.pi
        
        c = np.cos
        s = np.sin
        self.phi = phi
        self.theta = theta
        p = phi
        t = theta
        
        drehmatrix = np.zeros( (3,3) )
        self.r =  drehmatrix
        r = self.r
        
        r[0,0] = c(p)*c(t);   r[1,0] = -s(p);    r[2,0] = s(t)
        r[0,1] = s(p);        r[1,1] =  c(p);    r[2,1] = 0
        r[0,2] = -s(t);       r[1,2] = 0;        r[2,2] = c(t)
        
        print r
        

    def __call__( self, vector=None):
        
        if vector is None and not self.last_result is None:
            vector = self.last_result
        elif vector is None:
            raise ValueError("no argument given")
        turned_vector = vector.copy()
        t = turned_vector
        
        for i in range(3):
            t[i] = (self.r[i,:] * vector).sum()
        
        
        
        
        self.last_result = turned_vector
        return turned_vector
    
