import numpy as np

def length( v ):
    return np.sqrt(np.dot(v,v))
    
def uv_to_dir( u,v):
    dir = np.array([u, v, np.sqrt(1-u**2-v**2) ])
    return dir

def uv_to_theta_phi( u,v ):
    x,y,z = uv_to_dir(u,v).tolist()
    theta = np.arccos(z)
    phi = np.arctan2(y,x)
    return theta, phi
