#include <iostream>
#include <string>
#include "TObjArray.h"

#include "rootfilehandler.h"
#include <stdlib.h>
using namespace std;

/*
  POSSIBLE IMPROVEMENT:

  creat files on the heap and handover pointers

  */




void
CreateRootFile(
        TString         loc_fname,
        bool            overwrite,
        int             verbosityLevel
        )
{
    TFile* output_rootfile;

    if(!overwrite)
    {
        output_rootfile = new TFile(loc_fname);
        if (output_rootfile->IsZombie())
        {
            cout << "file does not exist...creating file" << endl;
            delete output_rootfile;
            output_rootfile = new TFile(loc_fname,"NEW");
        }
        else
        {
            cout << "file does exist and will be updated" << endl;
            output_rootfile->OpenFile(loc_fname,"UPDATE");
        }
    }
    else if(overwrite)
    {
        cout << "overwriting file" << endl;
        output_rootfile = new TFile(loc_fname,"RECREATE");
    }

    if (output_rootfile->IsZombie())
    {
        cout << "Error opening file" << endl;
        exit(-1);
    }
    else {
        if (verbosityLevel > 1) cout << "creating root-file...successfull" << endl;
        output_rootfile->pwd();
        output_rootfile->Close();
        delete output_rootfile;
    }
}
//end of CreateRootFile
//----------------------------------------------------------------------------


TFile*
ChooseRootFileToWrite(
        TString    loc_fname,
        int             verbosityLevel
        )
{
    TFile* output_rootfile = new TFile(loc_fname,"UPDATE");
    if (output_rootfile->IsZombie())
    {
        cout << "Error opening file" << endl;
        exit(-1);
    }
    else
    {
        if (verbosityLevel > 1)
        {
            cout << "...opening root-file:"
                 << loc_fname
                 << " successfull" << endl;
        }
    }
    return output_rootfile;
}
//end of WriteInRootFile
//----------------------------------------------------------------------------


void
CloseRootFile(
        TFile*          output_rootfile
        )
{
    if (output_rootfile->IsZombie())
    {
    cout << "Error closing file" << endl;
    exit(-1);
    } else {
    output_rootfile->Close();
    }
    delete output_rootfile;
}
//end of CloseRootFile
//----------------------------------------------------------------------------


void
SaveHistograms(
        TString         loc_fname,
        TString         subdirectory,
        TList*          histList,
        bool            saveResults,
        int             verbosityLevel
        )
{

    if (!saveResults) return;
    if (histList==NULL) return;
    if (verbosityLevel > 2) cout << endl
                                 << "...saving pixel histograms to subdirectory: "
                                 << subdirectory << endl ;

    TFile* output_rootfile = NULL;
    output_rootfile = ChooseRootFileToWrite( loc_fname, verbosityLevel);

    if (verbosityLevel > 2) cout << endl
                                 << "...writing histogram list to root file "
                                 << endl ;
    gFile->mkdir(subdirectory.Data());
    gFile->cd(subdirectory.Data());
    if (verbosityLevel > 1)
    {
        gDirectory->pwd();
    }
//    cout << histList;
    for ( int idx = 0; idx < histList->GetSize(); idx++)
    {
        histList->At(idx)->Write();
    }
//    gFile->WriteTObject(histList, subdirectory); // write the histograms into one Key in the top level directory
    gFile->cd("..");

    if (verbosityLevel > 3) output_rootfile->ls();
    CloseRootFile( output_rootfile ); // close the file
    if (verbosityLevel > 2) cout << "...done" << endl;
}
// end of SaveHistograms
//----------------------------------------------------------------------------

TString
CreateSubDirName(
        int pixel
        )
{
    TString path = "Pixel_";
    path += pixel;
//    cout << "path " << path << endl ;
    return path;
}
// end of CreateSubDirName
//----------------------------------------------------------------------------


TString
CreateSubDirName(
        TString         title
        )
{
    title += "_Pixel";
//    cout << "path " << path << endl ;
    return title;
}
// end of CreateSubDirName
//----------------------------------------------------------------------------

TFile*
OpenRootFile(
        TString         path,
        TString         filename,
        int             verbosityLevel
        )
{
    if (verbosityLevel > 1)
    {
        cout << "...opening root-file: ";
    }
    path += filename;
    TFile* file = TFile::Open( path );

    if (verbosityLevel > 1)
    {
        cout << path ;
        cout << " ...successfull" << endl;
    }
    return file;
}

TFile*
LoadRootFile(
        TString         path,
        TString         filename,
        int             verbosityLevel
        )
{
    if (verbosityLevel > 1)
    {
        cout << "...loading root-file: ";
    }
    path += filename;
    TFile* file = TFile::Open( path );

    if (file->IsZombie())
    {
        cerr << "file does not exist" << endl;
        delete file;
        return NULL;
    }
    else
    if (verbosityLevel > 1)
    {
        cout << path ;
        cout << " ...successfull" << endl;
    }
    return file;
}

TString
SetHostsPaths(
        bool    isInHomeDir,
        TString path
        )
{
    TString hostName = gSystem->HostName();
    TString dataDirectory;
    TString homeDirectory;

    TString temp_filename;

    if ( hostName.Contains("isdc") ) //IF ONE IS WORKING AT ISDC
    {
        cout << "computing site is ISDC" << endl;
        dataDirectory = "/fact/";
        homeDirectory = "/home_nfs/isdc/jbbuss/";
    }
    else if ( hostName.Contains("hpc")||hostName.Contains("node") ) //IF ONE IS WORKING AT PHIDO
    {
        cout << "computing site is PhiDO" << endl;
        dataDirectory = "/fhgfs/groups/app/fact-construction/";
        homeDirectory = "/fhgfs/users/jbuss/";
    }
    else
    {
        exit(-1);
    }
    if (!isInHomeDir)
    {
        temp_filename = dataDirectory;
        temp_filename += path;
        path = temp_filename;
    }
    else if (isInHomeDir)
    {
        temp_filename = homeDirectory;
        temp_filename += path;
        path = temp_filename;
    }

    return path;
}
