/**  container with all attributes and histograms of a pixel.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see something
 */

#ifndef PIXEL_H
#define PIXEL_H

// SYSTEM INCLUDES
//

// PROJECT INCLUDES
#include <TROOT.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TString.h>
#include <TFile.h>

#include "TCanvas.h"
#include "TObjArray.h"
//

//#include "rootfilehandler.h"
//#include "rootfilehandler.C"

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//


class Pixel
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    Pixel(
            int         pixelID,
            int         maxPulsorder,
            int         verbosityLevel,
            bool        stats,
            TString     options,
            int         pixelOverlayXaxisLeft,
            int         pixelOverlayXaxisRight,
            float       bSLMean,
            float       gainMean,
            TFile*      filename,
            TFile*      outfilename
            );

    Pixel(
            int         pixelID,
            int         maxPulsorder,
            int         verbosityLevel,
            bool        stats,
            TString     options,
            int         pixelOverlayXaxisLeft,
            int         pixelOverlayXaxisRight,
            float       bSLMean,
            float       gainMean
        );


    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */


    /** Destructor.
    */
    ~Pixel();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS

    //Histogram Booking
protected:
    void BookPixelHistos();
    void BookDistributionHistos();
    void BookTemplateHistos();
    void BookEdgeTemplateHistos();

    //Histogram deletion
    void DeletePixelHistos();
    void DeleteDistributionHistos();
    void DeleteTemplateHistos();
    void DeleteEdgeTemplateHistos();

    //Histogram appeareance
    void
    MakeTH1Pretty(
            TH1*                histo,
            TString             histName,
            TString             histTitle,
            int                 order
            );
    void
    MakeTH2Pretty(
            TH2*                histo,
            TString             histName,
            TString             histTitle,
            int                 order
            );
    void
    MakeTProfilePretty(
            TProfile*           histo,
            TString             histName,
            TString             histTitle,
            int                 order
            );

public:
    //Histogram Drawing
    void DrawOverlayHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNR   //Array with Canvas Frame numbers
            );
    void DrawDistributionHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );
    void DrawTemplateHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );
    void DrawEdgeTemplateHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );

    //File Handling
    void SavePixelHistograms( TString loc_fname, bool);

protected:
    void LoadPulseHistos( );

public:
    //File Handling Service Functions
    TString HistoTitle(TString, int );
    TString HistoName(TString, int);
    TString ChooseCycleNumber(TString , int);
    virtual TString CsvFileName(TString, TString, int );

    //fit funcitons
//    void FitFallingEdge(
//            TString             histoType,   //Max or Edge
//            double ,
//            double ,
//            TH1F*               hMaximumTemp
//            );

//    double
//    PolExp(double* x, double* par);

    //shifting
    void ShiftHistoInY(TH1*, float);




// ACCESS
// INQUIRY
    int             mChid;
    bool            mStats;
    int             mMaxPulseOrder;
    int             mVerbosityLevel;
    int             mPixelOverlayXaxisLeft;
    int             mPixelOverlayXaxisRight;
    float           mBSLMean;
    float           mGainMean;
    int             mMarkerStyle;
    TString         mOptions;

    //Pixel Histos
    TH2F**          hMaxOverlay;      //histogrammm for overlay of detected Peaks
    TH2F**          hEdgeOverlay;
    TProfile**      hMaxProfile;      //histogrammm for Profile of detected Peaks
    TProfile**      hEdgeProfile;  //histogrammm for Profile of detected Peaks

    //Distribution Histos
    TH1F**          hSlopeRisingEdge;
    TH1I**          hRisingEdgeToMax;
    TH1I**          hPosOfMax;
    TH1F**          hChi2EdgetoMax;

    //Max Overlay Template Histos
    TH1F**          hPixelMax;
    TH1F**          hPixelMedian;
    TH1F**          hPixelMean;
    //Edge OverlayTemplate Histos
    TH1F**          hPixelEdgeMax;
    TH1F**          hPixelEdgeMedian;
    TH1F**          hPixelEdgeMean;

    TList*          hList;

    TFile*          mRootFile;
    TFile*          mOutRootFile;
    TDirectory*     mDirectory;

protected:
    int             mConstructorType; //0 delete distributions, 1 delete TemplateHistos
private:
};



#endif  // _PIXEL_H_
