#!/usr/bin/python
##############################################################
#
#  CommunicateWithVME.py
#  Handles the communication with the VME crate
#  Sends commands to the VME crate
#
#  
#  Michael Rissi 05/2009
#
#############################################################

import GlobalVariables
import threading
import _VME
import time
import datetime

def GetStatus():
    print "Trigger thresholds: ", GlobalVariables.TriggerThresholds
    print "Hex Pattern: ", GlobalVariables.HexPattern
    print "Majority Level: ",GlobalVariables.MajorityLevel





def GetRate(module,channel):
    _VME.V560_Clear_Scales( module)
    beginCounter=_VME. V560_Read_Counter( module,  channel)
    GlobalVariables.ServerMessage = "Evaluating rates (2 seconds)..."
    time.sleep(2)
    endCounter = _VME. V560_Read_Counter( module,  channel)
    return (endCounter-beginCounter)/2000.



def GetRates(module):
    _VME.V560_Clear_Scales( module)
    beginCounter =[0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
    endCounter =  [0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
    rates      =  ["rates",
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
    
    for i in range(0,16):
        beginCounter[i]=_VME. V560_Read_Counter( module,  i)
        #GlobalVariables.ServerMessage = str(beginCounter[i])
    #GlobalVariables.ServerMessage = "Evaluating rates..."
    time.sleep(2)
    for i in range(0,16):
        endCounter[i] = _VME. V560_Read_Counter( module,  i)
        #GlobalVariables.ServerMessage = str(endCounter[i])
        rates[i+1] =(endCounter[i]-beginCounter[i])/2000.
    return rates


class GimmeRates(threading.Thread):
    rates=["rates",
        0,0,0,0,
           0,0,0,0,
           0,0,0,0,
           0,0,0,0]
    module = 1
    def run(self):
        oldcommand=GlobalVariables.UserInput
        while(GlobalVariables.UserInput[1:]!="exit" and GlobalVariables.UserInput[1:] != "EXIT"):
            time.sleep(0.001)
            newrates = GetRates(self.module)
            self.rates=newrates



        
class WriteOutput(threading.Thread):      #thread that writes the rates and threshold to a file.
    rates=["rates",
        0,0,0,0,
           0,0,0,0,
           0,0,0,0,
           0,0,0,0]
    interval = 2
    filename = "test.txt"
    #gimmeRates =GimmeRates()
    gimmeRates=GimmeRates()
    #File=open(filename,'a')
    def __init__(self, filename="test.txt", interval = 10):
        threading.Thread.__init__(self)
        #self.OpenNewFile(filename)



    def writeToFile(self):
        File = open(self.filename,'a')
        #print "writing", (GlobalVariables.Rates)
        #year = datetime.date.today().year
        #month = datetime.date.today().month
        #day = datetime.date.today().day
        year = time.localtime(time.time())[0]
        month =time.localtime(time.time())[1]
        day = time.localtime(time.time())[2]
        hour = time.localtime(time.time())[3]
        minute = time.localtime(time.time())[4]
        seconds = time.localtime(time.time())[5]
        ms = time.localtime(time.time())[6]
        #date=str(year)
        #if (hour>=12):
        #    day = day+1

        t = datetime.datetime.now()
        EpochSeconds=int(time.mktime(t.timetuple()))

        outstring = "Trigger " + " ThreshRate "+str(year) + " " + str(month) +" " + str(day) +" "+str(hour)+" " + str(minute) + " " + str(seconds)+ " "+str(ms)+" "+str(EpochSeconds)+" Thresh: "
        File.write(outstring)
        #print outstring
        File.write(str(GlobalVariables.TriggerThresholds[0:]).strip('[]').replace(',', ''))
        File.write(" rate: ")
        GlobalVariables.Rates = self.gimmeRates.rates
        File.write(str(GlobalVariables.Rates[0:]))#.strip('[]').replace(',', ''))
        #print str(GlobalVariables.Rates[0:]).strip('[]').replace(',', ''))

      
        #print str(GlobalVariables.TriggerThresholds[0:]).strip('[]').replace(',', '')
        #print "\n"
        
        File.write("\n")
        File.close();



    def run(self):
        self.gimmeRates.start()
        while(GlobalVariables.UserInput[1:]!="exit" and GlobalVariables.UserInput[1:] != "EXIT"):
            time.sleep(0.001)
            time.sleep(self.interval)
            self.writeToFile() 







        
    


class ParseUserInput(threading.Thread):
    gimmeRates=GimmeRates()
    writeOutput=WriteOutput()
    def Parse(self,Command):
        Command = Command[1:]
        #GlobalVariables.ServerMessage = "PARSING: " + Command
        sCommand=Command.split()
        error_code=0
        #python lacks switch...
        try:
            VMEModule=sCommand[0]
            if(VMEModule == "help"):
                GlobalVariables.ServerMessage = "please use \'<V812|V560|Triggerboard> help\' "
                #GlobalVariables.ServerMessage="please use \'<V812|V560|Triggerboard> help\' "
            
            # now do the stuff for the V560:
            if(VMEModule == "V560"):
                V560Command=sCommand[1]
                if(V560Command=="help"):
                    GlobalVariables.ServerMessage = "available functions are: \n"
                    GlobalVariables.ServerMessage += "V560 GetRate <module#> <channel#>\n"
                    GlobalVariables.ServerMessage += "V560 GetRates <module#\n "
                    time.sleep(0.05)
                    
                if(V560Command=="GetRate"):
                    #GlobalVariables.ServerMessage = "trying to get rate"
                    #time.sleep(0.05)
                    

                    try:
                        module = int(sCommand[2])
                        channel= int(sCommand[3])
                        if(module!= self.gimmeRates.module):
                            self.gimmeRates.module=module
                            GlobalVariables.ServerMessage = "please wait... (5sec)"
                            time.sleep(5)
                        
                        GlobalVariables.ServerMessage = str(self.gimmeRates.rates[channel])
                        time.sleep(0.01)
                    except:
                        GlobalVariables.ServerMessage = "Syntax Error (GetRate)"
                        time.sleep(0.01)
                    #GlobalVariables.Rates[int(channel)] = GetRates(int(module),int(channel))

                if(V560Command=="GetRates" or V560Command=="GR"):
                    #GlobalVariables.ServerMessage = "trying to get rates"
                    #time.sleep(0.01)
                    try:
                        module = int(sCommand[2])
                        if(module!= self.gimmeRates.module):
                            self.gimmeRates.module=module
                            GlobalVariables.ServerMessage = "please wait... (5sec)"
                            time.sleep(5)
                        #GlobalVariables.ServerMessage = "RATES:"
                        GlobalVariables.ServerMessage = str(self.gimmeRates.rates)
                        time.sleep(0.01)
                    except:
                        GlobalVariables.ServerMessage = "Syntax Error (GetRates)"
                        time.sleep(0.05)
                    #GlobalVariables.Rates[int(channel)] = GetRates(int(module),int(channel))
        

            # now do the stuff for the V812:
            elif(VMEModule == "V812"):
                V812Command=sCommand[1]
                if(V812Command=="help"):
                    GlobalVariables.ServerMessage  = "available functions are: \n"
                    GlobalVariables.ServerMessage += "V812 SetHexPat <module#[1-10]> <HexPattern[0x0000-0xFFFF>\n"
                    GlobalVariables.ServerMessage += "V812 SetThresh <module#[1-10]> <channel#[0-15]> <thresh[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetThreshDiff <module#[1-10]> <channel#[0-15]> <threshdiff[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetAllThresh <module#[1-10]>  <thresh[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetAllThreshDiff <module#[1-10]>  <threshdiff[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetMajLevel <module#[1-10]> <MajLev[1-20]>\n"
                    GlobalVariables.ServerMessage += "V812 SetMajThresh <module#[1-10]> <MajThr[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetDeadTime <module#[1-10]> <Block [0-1]> <DeadTime[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 SetOutputWidth <module#[1-10]> <Block [0-1]> <OutputWidth[0-255]>\n"
                    GlobalVariables.ServerMessage += "V812 Status\n"
                    GlobalVariables.ServerMessage += "V812 RateScan <module> <start> <step> <stop>\n"
                    
                    time.sleep(0.05)
                #set the hexpattern:
                elif(V812Command=="SetHexPat"):
                    GlobalVariables.ServerMessage = "trying to set the hexpattern:"
                    time.sleep(0.05)
                    try:
                        module = int(sCommand[2])
                        hexpat = int(sCommand[3],16)
                        #print hexpat
                        # hexpat="ddd"
                        GlobalVariables.ServerMessage = "setting module "+str(module)+" to hexpat: "+str(hex(hexpat))
                        time.sleep(0.05)
                        try:
                            print "setting it now..."
                            error_code=_VME.V812_Set_Pattern_Inhibit_Hex(module, hexpat)
                            GlobalVariables.ServerMessage = "success! "
                            GlobalVariables.HexPattern =str(hex(hexpat))
                            time.sleep(0.05)
                            
                        except:
                            VME_ErrorPrint(error_code)
                            print "FAILED"
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetHexPat)"

                        
                        time.sleep(0.05)
                elif(V812Command=="SetAllThresh"):
                    print "trying to set the threshold:"
                    try:
                        module  = int(sCommand[2])
                        thresh  = int(sCommand[3])
                        GlobalVariables.ServerMessage="Setting all thresholds...\n"
                        for channel in range(0,16):
                            GlobalVariables.ServerMessage += "setting threshold of channel: "+str(channel)+ " in module "+str(module)+" to: "+str(thresh)+"\n"
                            GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Threshold(module, channel,  thresh))+"\n"
                            GlobalVariables.TriggerThresholds[channel] = thresh
                        time.sleep(0.05)
                            
                            
                    except:
                        print "Syntax error (SetAllThresh) "

                elif(V812Command=="SetAllThreshDiff"):
                    print "trying to set all the threshold (diff):"
                    try:
                        module      = int(sCommand[2])
                        threshdiff  = int(sCommand[3])
                        GlobalVariables.ServerMessage="Setting all thresholds (diff)...\n"
                        for channel in range(0,16):
                            GlobalVariables.ServerMessage += "increase threshold of channel: "+str(channel)+ " in module "+str(module)+" by: "+str(threshdiff)+"\n"
                            GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Threshold(module, channel, GlobalVariables.TriggerThresholds[channel]+ threshdiff))+"\n"
                            GlobalVariables.TriggerThresholds[channel]+= threshdiff
                        time.sleep(0.05)
                            
                            
                    except:
                        print "Syntax error (SetAllThreshDiff) "

                elif(V812Command=="SetThreshDiff"):
                    GlobalVariables.ServerMessage = "trying to set the threshold:"
                    time.sleep(0.05)
                    try:
                        module      = int(sCommand[2])
                        channel     = int(sCommand[3])
                        threshdiff  = int(sCommand[4])
                        #print module, channel, threshdiff
                        #print GlobalVariables.TriggerThresholds[channel]
                        newthresh = GlobalVariables.TriggerThresholds[channel] + threshdiff
                        #print newthresh
                        GlobalVariables.ServerMessage = "increase threshold of channel: "+str(channel)+ " in module "+str(module)+" by: "+str(threshdiff)+"\n"
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Threshold(module, channel,newthresh))
                        GlobalVariables.TriggerThresholds[channel] = newthresh
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetThreshDiff) "
                        time.sleep(0.05)
            
                elif(V812Command=="SetThresh"):
                    GlobalVariables.ServerMessage = "trying to set the threshold:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        channel = int(sCommand[3])
                        thresh  = int(sCommand[4])
                        GlobalVariables.ServerMessage = "setting threshold of channel: "+str(channel)+ " in module "+str(module)+" to: "+str(thresh)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Threshold(module, channel,  thresh))
                        GlobalVariables.TriggerThresholds[channel] = thresh
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetThresh) "
                        time.sleep(0.05)
                elif(V812Command=="SetMajLevel"):
                    GlobalVariables.ServerMessage = "trying to set the majority level:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        level   = int(sCommand[3])
                        GlobalVariables.ServerMessage = "setting maj. level of module "+str(module)+" to: "+str(level)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Majority_Level(module,level))
                        GlobalVariables.MajorityLevel = level
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetMajLevel)"
                        time.sleep(0.05)

                elif(V812Command=="SetMajThresh"):
                    GlobalVariables.ServerMessage = "trying to set the majority threshold:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        thresh  = int(sCommand[3])
                        GlobalVariables.ServerMessage = "setting maj. level of module "+str(module)+" to: "+str(thresh)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Majority_Threshold(module,  thresh))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetMajThresh)"
                        time.sleep(0.05)

                elif(V812Command=="SetDeadTime"):
                    GlobalVariables.ServerMessage = "trying to set deadtime threshold:"
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        block  = int(sCommand[3])
                        deadtime= int(sCommand[4])
                        GlobalVariables.ServerMessage = "setting deadtime of module "+str(module)+" block: "+str(block)+ " to: "+str(deadtime)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Dead_Time(module, block, deadtime))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetDeadTime)"
                        time.sleep(0.05)
                elif(V812Command=="SetOutputWidth"):
                    GlobalVariables.ServerMessage = "trying to set output width "
                    time.sleep(0.05)
                    try:
                        module  = int(sCommand[2])
                        block  = int(sCommand[3])
                        outputw= int(sCommand[4])
                        GlobalVariables.ServerMessage = "setting output width of module "+str(module)+" block: "+str(block)+ " to: "+str(outputw)
                        GlobalVariables.ServerMessage += "success: "+str(_VME.V812_Set_Output_Width(module, block, outputw))
                        time.sleep(0.05)
                    except:
                        GlobalVariables.ServerMessage = "Syntax error (SetOutputTime)"
                        time.sleep(0.05)
                elif(V812Command=="Status"):
                    GetStatus();

                elif(V812Command=="RateScan"):
                    GlobalVariables.ServerMessage = "trying to scan the rates "
                    time.sleep(0.05)
                    try:
                        module = int(sCommand[2])
                        start  = int(sCommand[3])
                        step   = int(sCommand[4])
                        stop   = int(sCommand[5])
                        print module, start, step, stop
                        self.RateScan(module, start, step, stop)


                    except:
                        GlobalVariables.ServerMessage = "Syntax error (RateScan)"
                        time.sleep(0.05)
                        


                    
                else:
                    GlobalVariables.ServerMessage = "Syntax Error (V812)"
                    time.sleep(0.05)
                
                        
        except:
            GlobalVariables.ServerMessage = "syntax error"
            time.sleep(0.05)
    def RateScan(self,module, start, step, stop):
        #print module, start, step,stop
        #print "IN\n"
        #First stop the automatic rate writeup
        oldinterval = self.writeOutput.interval
        self.writeOutput.interval=15
        rates      =  ["rates",
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
        print "rates:" ,rates
        CurrentThresholds =[0,0,0,0,
                   0,0,0,0,
                   0,0,0,0,
                   0,0,0,0]
        for pix in range(0,16):
            CurrentThresholds[pix] = GlobalVariables.TriggerThresholds[pix]
        print "Threshs: ",CurrentThresholds,"\n"
        NumberOfScanSteps = int((stop-start)/step) + 1
        print "NumberOfScanSteps: ",  NumberOfScanSteps
        for StepNumber in range(0,NumberOfScanSteps):
            print "Step#" ,StepNumber
            for pix in range(0,16):
                #print (CurrentThresholds[pix] + start) + step*StepNumber
                GlobalVariables.TriggerThresholds[pix] = (CurrentThresholds[pix] + start) + step*StepNumber
                #print pix, GlobalVariables.TriggerThresholds[pix] 
                _VME.V812_Set_Threshold(module, pix,   GlobalVariables.TriggerThresholds[pix])

            time.sleep(2.1)
            #print "Getting Rates: \n"
            rates = self.gimmeRates.rates#GetRates(module);
            self.writeOutput.writeToFile()
            #print "Got rates..."
            print  "Thresh: ",GlobalVariables.TriggerThresholds, " rates: ",rates    #_VME.V812_Set_Threshold(1, 0,  255)


        self.writeOutput.interval = oldinterval
    
    def __init__(self):
        #self.writeOutput.OpenNewFile("test.txt")
        threading.Thread.__init__(self)
    def run(self):
        self.gimmeRates.start()
        
        self.writeOutput.start()
        oldcommand=GlobalVariables.UserInput
        while(GlobalVariables.UserInput[1:]!="exit" and GlobalVariables.UserInput[1:] != "EXIT"):
            CommandToParse=GlobalVariables.UserInput
            #Filename to write:
            #year = datetime.date.today().year
            #month = datetime.date.today().month
            #day = datetime.date.today().day
            MyTime = time.time()
            #print MyTime
        
           
            hour = time.gmtime(MyTime)[3]
            minute = time.gmtime(MyTime)[4]
            #print hour, minute
            if(hour>=13):
                MyTime+=12*60*60

            year = time.gmtime(MyTime)[0]
            month =time.gmtime(MyTime)[1]
            day = time.gmtime(MyTime)[2]
            date=str(year)
            #if (hour>=12):
            #    day = day+1
            
            date+="%(month)02d" % {"month":month}
            date+="%(day)02d" % {"day":day}
            #date+="_"
            #date+="%(hour)02d" % {"hour":hour}
            #date+="%(minute)02d" % {"minute":minute}
            self.writeOutput.filename="/ct3data/SlowData/Trigger_"+date+".slow"

            
            #self.writeOutput.filename = "/ct3data/SlowData/Trigger_"
            #self.writeOutput.filename
            if(oldcommand!=CommandToParse):
                self.Parse(CommandToParse)
                oldcommand=CommandToParse
            time.sleep(0.05)


            
        GlobalVariables.ServerMessage = "EXITING PARSER...press <enter> to exit"
        time.sleep(0.05)
            
