/********************** FPulseTemplate ***********************
* open a root-file with pulse overlay histograms
* calculate most propable Pulse-Shape
* compute pulse height and pulse integral spektrum of the peaks
+ draw histos for single, double, tripple, ....above 100mV Photonpulses
+ draw Parameterdevelopment depending on photon quantity
+ form a template (shape depending on number of photons)
  so it can be used for detection of other peaks
*************************************************************/

//----------------------------------------------------------------------------
// root libraries
//----------------------------------------------------------------------------

#include <TROOT.h>
#include <TCanvas.h>
#include <TTimer.h>
#include <Getline.h>
#include <TMath.h>
#include <TFile.h>
#include <TGraph.h>
#include <TGraphErrors.h>
#include <TStyle.h>
#include <TString.h>
#include <TF1.h>

#include <stdio.h>
#include <stdint.h>
#include <cstdio>
#include <iostream>
#include <fstream>

#include <vector>
#include <utility>

using namespace std;

#define NPIX  1440
#define NCELL 1024
#define FAD_MAX_SAMPLES 1024
#define MAX_PULS_ORDER 1
#define HAVE_ZLIB

//----------------------------------------------------------------------------
// Classes
//----------------------------------------------------------------------------
#include "rootfilehandler.h"
#include "pixel.h"
#include "pixelsum.h"
#include "pulse.h"
#include "templateextractors.h"
#include "configfile.h"
#include "csv.h"

//----------------------------------------------------------------------------
// Decleration of global variables
//----------------------------------------------------------------------------
bool breakout=false;

//----------------------------------------------------------------------------
// Initialisation of Root Objects
//----------------------------------------------------------------------------

// Temporary Objects

//Pixelwise Histograms

//All Pixel Histograms

//Root-File Objects
TObjArray*  hAllPixelList       = NULL;
TObjArray*  hRootList           = NULL;

//Canvases
TCanvas**   cgpPixelPulses      = NULL;
TCanvas**   cgpAllPixelPulses   = NULL;
TCanvas**   cgpDistributions    = NULL;
TCanvas*    cgpGraphs           = NULL;
//TCanvas*    cgpTestHistos       = NULL;

//----------------------------------------------------------------------------
// Functions
//----------------------------------------------------------------------------
void DeletePixelCanvases( int, int );
void
UpdateCanvases(
        int verbosityLevel,
        int max_pulse_order,
        bool testmode
        );

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// MAIN - Funtion
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
int FCalcPulseTemplate(

        // ------------{ Files }------------
//        TString     InRootFileName        = "20120802_0mV_newSelectAlg.root",
        TString     InRootFileName          = "20120802_0mV_Stacking_G11B-2AWW8.root",
//        TString     InRootFileName          = "20120802_200mV_Stacking_G13B-2AWW8.root",
        TString     InputPath               = "analysis/PulsTemplateAnalysis/20120802/",
        TString     OutputRootFileName      = "20120802_0mV_Extraction_G11B-2AWW8_model2.root",
//        TString     OutputRootFileName      = "20120802_200mV_Extraction_G13B-2AWW8_model0.root",
        TString     OutPutPath              = "analysis/PulsTemplateAnalysis/20120802/",
        //    TString     InRootFileName        = "20120309_032.root",
        //    TString     InRootFileName        = "20120309_017.root",
        //    TString     InputPath           = "analysis/analysis/FPulseTemplate/20120309_017/Overlay/",
        //    TString     InputPath           = "analysis/analysis/FPulseTemplate/20120309_032/Overlay/",
        // ------------{ data quantity }------------
        int     firstpixel              = 0,
        int     npixel                  = 1,
        int     pixelSetSize            = 200,
        int     maxPulseOrder           = 6,
        // ------------{ analysis parameters }------------
        float   meanGain                = 11.,
        float   meanBsl                 = -2.5,
        int     bootstrapIt             = 10,
        int     pulseModell             = 0,
        float   pixelOverlayXaxisLeft   = 0,
        float   pixelOverlayXaxisRight  = 400,

        // ------------{ program options }------------
        //    TString     histoOptions        = "SRM",

        // show graphical output
        bool        ProduceGraphic      = true,

        // show stats in plots
        bool        stats               = true,

        // save data
        bool        saveResults         = false,
        //    bool        fitdata             = false,

        //pause after each pixel
        bool        debugPixel          = true,

        //refresh rate for canvases
        //    int         refresh_rate        = 500,

        TString fitOption = "Q",

        // different verbosity levels can be set here
        int         verbosityLevel      = 1
        )
{

    InputPath       = SetHostsPaths(true, InputPath );
    OutPutPath      = SetHostsPaths(true, OutPutPath );

    TString outFile  = OutPutPath;
    outFile         += OutputRootFileName;

//----------------------------------------------------------------------------
//	Open-Root-File Settings
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...load root file" << endl;
    }

    TFile * inputRootFile
            = LoadRootFile( InputPath, InRootFileName, verbosityLevel );

    if (inputRootFile == NULL)
    {
        cerr << "input file not readable, check file path!!!" << endl;
        return(0);
    }
    if (saveResults)
    {
        CreateRootFile( outFile, true, verbosityLevel );
    }

    TFile * outputRootFile
            = OpenRootFile( OutPutPath, OutputRootFileName, verbosityLevel );
//----------------------------------------------------------------------------
//	Define operation range
//----------------------------------------------------------------------------
    if ( npixel == -1 )
    {
        npixel = NPIX - firstpixel;
    }


    if ( pixelSetSize == -1 )
    {
        pixelSetSize = firstpixel +npixel;
    }

//    float GainMean  = GainMean;  // this has to be extracted from root files
//    float BSLMean   = BSLMean;    // this has to be extracted from root files

//----------------------------------------------------------------------------
//	root global Settings
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...setting up root environment" ;
    }

    gStyle->SetPalette(1,0);
    gROOT->SetStyle("Plain");
//    gPad->SetGrid();



//----------------------------------------------------------------------------
//	root Canvas Settings
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...preparing canvases" << endl;
    }

    //Canvas Pad numbering
    int PixelCanvasFrameNrs[8]      =
    {
        1,  // Top left
        2,  // Top mid left
        3,  // Top mid right
        4,  // Top right
        5,  // bootom left
        6,  // bootom mid left
        7,  // bottom mid right
        8   // bootom right
    };

//    //Canvas Pad numbering
//    int DistributionCanvasFrameNrs[4]   = {
//        1,  // Top left
//        2,  // Top right
//        3,  // bottom left
//        4   // bootom right
//    };

    if (ProduceGraphic)
    {

        //Canvases
        cgpPixelPulses              = new TCanvas*[maxPulseOrder];
        cgpDistributions            = new TCanvas*[maxPulseOrder];
        cgpGraphs                   = new TCanvas("graphs", "Dependences to pe" );

        //TCanvas*    gpcDevelopment = NULL;
        TString cName               = "";
        TString cTitle              = "";

        //naming of pulse canvases
        for (
             int pulse_order = maxPulseOrder - 1;
             pulse_order >= 0 ;
             pulse_order--
              )
        {
            cName   ="cgpDistributions";
            cName  += pulse_order;

            cTitle  ="Distributions of Pulses with Order of: ";
            cTitle += pulse_order;

            cgpDistributions[pulse_order]
                    = new TCanvas(cName,cTitle, 720,pulse_order*20,720,720);
//            cgpDistributions[pulse_order]->Divide(2, 2);

            cName   ="cgpPixelPulses";
            cName  += pulse_order;

            cTitle  ="Overlays of Pulses with Order of: ";
            cTitle  += pulse_order;

            cgpPixelPulses[pulse_order]
                     = new TCanvas(cName,cTitle, 0,pulse_order*20,800,800);
            cgpPixelPulses[pulse_order]->Divide(4, 2);
        }

        cgpGraphs->Divide(1,3);
    }

//-----------------------------------------------------------------------------
// Filter-Settings
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Distrribution Histograms
//-----------------------------------------------------------------------------
    TH1D hBsl[maxPulseOrder];
    TH1D hAsymptote[maxPulseOrder];
    TH1D hT0[maxPulseOrder];
    TH1D hTau1[maxPulseOrder];
    TH1D hTau2[maxPulseOrder];
    TH1D hIntegral[maxPulseOrder];
    TH1D hAmplitude[maxPulseOrder];
    TH1D hRiseTime[maxPulseOrder];
    TList* histoList = new TList();

    //Lopp over pulse order configure distribution histograms
    for (int i = 0; i<maxPulseOrder; i++)
    {
        //BSL
        TString title;
        title = "hBSL";
        title += "_";
        title += i;
        hBsl[i].SetNameTitle(title, title);
        hBsl[i].SetBins(800, -4-0.005, 4-0.005);
        histoList->Add( &hBsl[i] );
        //Asymptote
        title = "hAsymptote";
        title += "_";
        title += i;
        hAsymptote[i].SetNameTitle(title, title);
        hAsymptote[i].SetBins(60, -10.5, 49.5);
        histoList->Add( &hAsymptote[i] );

        //T0
        title = "hT0";
        title += "_";
        title += i;
        hT0[i].SetNameTitle(title, title);
        hT0[i].SetBins(80, 39.5, 119.5);
        histoList->Add( &hT0[i] );

        //Tau1
        title = "hTau1";
        title += "_";
        title += i;
        hTau1[i].SetNameTitle(title, title);
        hTau1[i].SetBins(10, -10.5, 9.5);
        histoList->Add( &hTau1[i] );

        //Tau2
        title = "hTau2";
        title += "_";
        title += i;
        hTau2[i].SetNameTitle(title, title);
        hTau2[i].SetBins(40, 19.5, 59.5);
        histoList->Add( &hTau2[i] );

        //Integral
        title = "hIntegral";
        title += "_";
        title += i;
        hIntegral[i].SetNameTitle(title, title);
        hIntegral[i].SetBins(500, (i+1)*-0.5, (i+1)*499.5);
        histoList->Add( &hIntegral[i] );

        //Amplitude
        title = "hAmplitude";
        title += "_";
        title += i;
        hAmplitude[i].SetNameTitle(title, title);
        hAmplitude[i].SetBins(400, (i+1)*4.95, (i+1)*24.95);
        histoList->Add( &hAmplitude[i] );

        //hRiseTime
        title = "hRiseTime";
        title += "_";
        title += i;
        hRiseTime[i].SetNameTitle(title, title);
        hRiseTime[i].SetBins(20, -0, 10);
        histoList->Add( &hRiseTime[i] );
    }

    // Error Histograms

    TH1D hMedianErrors[maxPulseOrder];
    TH1D hMeanErrors[maxPulseOrder];
    TH1D hMaxErrors[maxPulseOrder];

    //Lopp over pulse order configure distribution histograms
    float roi = 1024.;
    for (int i = 0; i<maxPulseOrder; i++)
    {
        //hMedianErrors
        TString title;
        title = "hMedianErrors";
        title += "_";
        title += i;
        hMedianErrors[i].SetNameTitle(title, title);
        hMedianErrors[i].SetBins(roi, -0.5, roi + 0.5);

        //hMeanErrors
        title = "hMeanErrors";
        title += "_";
        title += i;
        hMeanErrors[i].SetNameTitle(title, title);
        hMeanErrors[i].SetBins(roi, -0.5, roi + 0.5);

        //hMaxErrors
        title = "hMaxErrors";
        title += "_";
        title += i;
        hMaxErrors[i].SetNameTitle(title, title);
        hMaxErrors[i].SetBins(roi, -0.5, roi + 0.5);
    }


//-----------------------------------------------------------------------------
// Graphs
//-----------------------------------------------------------------------------
    TGraphErrors grPheVsAmpl;
    grPheVsAmpl.SetNameTitle("grPheVsAmpl", "Distribution of Pulse Amplitude vs. Photon equivalent");
    grPheVsAmpl.SetMarkerStyle(21);
    histoList->Add( &grPheVsAmpl );

    TGraphErrors grPheVsIntegral;
    grPheVsIntegral.SetNameTitle("grPheVsIntegral", "Distribution of Pulse Integral vs. Photon equivalent");
    grPheVsIntegral.SetMarkerStyle(21);
    histoList->Add( &grPheVsIntegral );

    TGraphErrors grPheVsTau2;
    grPheVsTau2.SetNameTitle("grPheVsTau2", "Distribution of Tau2 vs. Photon equivalent");
    grPheVsTau2.SetMarkerStyle(21);
    histoList->Add( &grPheVsTau2 );
//-----------------------------------------------------------------------------
// Variables
//-----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Initialize Pixels
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...preparing pixels" << endl;
    }

    Pixel**     pixel       = new Pixel*[NPIX];

    for (int i = 0 ; i < NPIX; i++)
    {
        pixel[i] = NULL;
    }

    PixelSum*   wholeCamera = NULL;

    bool        first_pass  = true;

//----------------------------------------------------------------------------
// Initialize Outputfiles
//----------------------------------------------------------------------------

    Csv PixelCsv(OutPutPath, InRootFileName.Remove(12, 5), "points", verbosityLevel);
    PixelCsv.WritePointSetHeader();
    Csv PixelModelCsv(OutPutPath, InRootFileName.Remove(12, 5), "fitResults", verbosityLevel);
    PixelModelCsv.WritePulseAttributesHeader();
//    Csv AllPixelCsv(OutPutPath, InRootFileName.Remove(12, 5), -1, verbosityLevel);
//    Csv AllPixelModelCsv(OutPutPath, InRootFileName.Remove(12, 5), "AllPixelModel", verbosityLevel);

    TCanvas pulses("Templates","Templates", 0,0,1200,600);
    pulses.Divide(3,1);
//-------------------------------------
// Loop over Pixel Sets
//-------------------------------------
    for ( int firstPixelOfSet = firstpixel;
          firstPixelOfSet < firstpixel + npixel;
          firstPixelOfSet += pixelSetSize )
    {
        if (verbosityLevel >= 0)
        {
            cout << "------------------------------------------------"
                 << endl
                 << "...processing Pixel: "
                 << firstPixelOfSet
                 << " to Pixel: "
                 << firstPixelOfSet+pixelSetSize-1
                 << endl;
        }

        //--------------------------------------------------------------------
        // Loop over every Pixel of a Set of Pixels
        //--------------------------------------------------------------------
        for ( int pixelID = firstPixelOfSet;
              pixelID < firstPixelOfSet + pixelSetSize
              && pixelID < firstpixel + npixel;
              pixelID++ )
        {
            if (verbosityLevel >= 0)
            {
                cout << "------------------------------------------------"
                     << endl
                     << "...processing Pixel: "
                     << pixelID << "/"
                     << firstPixelOfSet + pixelSetSize - 1
                     << endl;
            }
            if (verbosityLevel > 1)
            {
                cout << "-------------------------------------"
                     << endl
                     << "...processing Set from Pixel "
                     << firstPixelOfSet
                     << " to Pixel "
                     << firstPixelOfSet+pixelSetSize-1
                     << " Pixel: " << pixelID
                     << "/" << firstpixel + npixel -1
                     << endl;
            }

            //-------------------------------------
            // Create individual Pixel
            //-------------------------------------
            if (verbosityLevel > 3)
            {
                cout << "...creating pixel: " << pixelID << endl;
            }

           pixel[pixelID] = new Pixel(
                       pixelID,
                       maxPulseOrder,  ///One should get this from the file
                       verbosityLevel,
                       stats,
                       "L",
                       pixelOverlayXaxisLeft,   //TODO: get it from the root file
                       pixelOverlayXaxisRight,  //TODO: get it from the root file
                       meanBsl,   //bslMean     /TODO: get it from the root file
                       meanGain,    //gain mean /TODO: get it from the root file
                       inputRootFile,
                       outputRootFile
                    );

            if (breakout)   break;

            //-------------------------------------
            // Histogramms of Maximas in Overlay Spectra
            //-------------------------------------

            for ( int pulse_order = 0 ;
                  pulse_order < pixel[pixelID]->mMaxPulseOrder ;
                  pulse_order ++)
            {
                if (verbosityLevel > 2)
                {
                    cout << "-------------------------------------"
                         << endl
                         << "...processing Set from Pixel "
                         << firstPixelOfSet
                         << " to Pixel "
                         << firstPixelOfSet+pixelSetSize-1
                         << " Pixel: " << pixelID
                         << "/" << firstpixel + npixel -1
                         << " Pulse-Order: " << pulse_order
                         << endl;
                }

                // Calculate Max Prop. Value of each slice
                //-------------------------------------

//                pixel[pixelID]->Normalize2Dhistos(pulse_order);

                //from Maximum Overlay
                if (verbosityLevel > 2)
                {
                    cout << "...extracting templates from Maximum Overlay "
                         << endl;
                }

                ExtractPulseTemplate(
                            pixel[pixelID],
                            "Maximum",
                            pulse_order,
                            10,
                            verbosityLevel
                            );

                //from Edge Overlay
                if (verbosityLevel > 2)
                {
                    cout << "...extracting templates from Edge Overlay "
                         << endl;
                }
                ExtractPulseTemplate(
                            pixel[pixelID],
                            "Edge",
                            pulse_order,
                            10,
                            verbosityLevel
                            );

                pixel[pixelID]->SetRangeUser(pixelOverlayXaxisLeft, pixelOverlayXaxisRight, pulse_order);


                PixelCsv.WritePointSet(
                            pixel[pixelID],
                            "Maximum",
                            pulse_order
                            );

                PixelCsv.WritePointSet(
                            pixel[pixelID],
                            "Edge",
                            pulse_order
                            );

                if ( saveResults )
                {
                    WritePixelTemplateToCsv(
                                pixel[pixelID],
                                OutPutPath,
                                "Maximum",
                                pulse_order,
                                verbosityLevel
                                );

                    WritePixelTemplateToCsv(
                                pixel[pixelID],
                                OutPutPath,
                                "Edge",
                                pulse_order,
                                verbosityLevel
                                );
                }

                if (ProduceGraphic && debugPixel)
                {

                    pixel[pixelID]->DrawTemplateHistograms(
                                cgpPixelPulses,
                                PixelCanvasFrameNrs
                                );

                    pixel[pixelID]->DrawEdgeTemplateHistograms(
                                cgpPixelPulses,
                                PixelCanvasFrameNrs
                                );

//                    cgpPixelPulses[pulse_order]->cd(6);


                    //-------------------------------------
                    //-------------------------------------
                    // Test Area
                    //-------------------------------------
                    //-------------------------------------

                    cgpPixelPulses[pulse_order]->cd(8);

                    //-------------------------------------
                    //-------------------------------------
                    // EOF Test Area
                    //-------------------------------------
                    //-------------------------------------
                }

                // =======================================================
                //  Fit of pulse function to template

                Pulse* pulseFits[6];

//                pulses.cd(1);
                Pulse maxMaxPulse("maxMaxPulse", pixel[pixelID]->hPixelMax[pulse_order], fitOption, pulseModell,pulse_order);
                pulseFits[0] = &maxMaxPulse;

//                pulses.cd(2);
                Pulse maxMedianPulse("maxMedianPulse", pixel[pixelID]->hPixelMedian[pulse_order], fitOption,pulseModell,pulse_order);
                pulseFits[1] = &maxMedianPulse;

//                pulses.cd(3);
                Pulse maxMeanPulse("maxMeanPulse", pixel[pixelID]->hPixelMean[pulse_order], fitOption,pulseModell,pulse_order);
                pulseFits[2] = &maxMeanPulse;

                Pulse edgeMaxPulse("edgeMaxPulse", pixel[pixelID]->hPixelEdgeMax[pulse_order], fitOption,pulseModell,pulse_order);
                pulseFits[3] = &edgeMaxPulse;

                Pulse edgeMedianPulse("edgeMedianPulse", pixel[pixelID]->hPixelEdgeMedian[pulse_order], fitOption,pulseModell,pulse_order);
                pulseFits[4] = &edgeMedianPulse;

                Pulse edgeMeanPulse("edgeMeanPulse", pixel[pixelID]->hPixelEdgeMean[pulse_order], fitOption,pulseModell,pulse_order);
                pulseFits[5] = &edgeMeanPulse;


                //--------------------------------------------------------
                //Write parameters from pulse fit to CSV

                for (int i = 0; i < 6; i++)
                {
                    PixelModelCsv.WritePulseAttributes(
                                pixel[pixelID],
                                pulseFits[i],
                                "Edge_pix",
                                pulse_order
                                );
                }
                //-------------------------------------
                // Fill Error Histogramms
                //-------------------------------------

                for (int i = pixel[pixelID]->hPixelEdgeMedian[pulse_order]->GetXaxis()->GetFirst();
                     i <= pixel[pixelID]->hPixelEdgeMedian[pulse_order]->GetXaxis()->GetLast();
                     i++)
                {

                    hMedianErrors[pulse_order].SetBinContent(
                                i,
                                pixel[pixelID]->hPixelEdgeMedian[pulse_order]->GetBinError(i)
                                );

                    hMeanErrors[pulse_order].SetBinContent(
                                i,
                                pixel[pixelID]->hPixelEdgeMean[pulse_order]->GetBinError(i)
                                );

                    hMaxErrors[pulse_order].SetBinContent(
                                i,
                                pixel[pixelID]->hPixelEdgeMax[pulse_order]->GetBinError(i)
                                );
                }

                if (ProduceGraphic && debugPixel)
                {
                    int current_order = 0;
                    pulses.cd(1);
                    hMaxErrors[current_order].Draw();

                    pulses.cd(2);
                    hMedianErrors[current_order].Draw();

                    pulses.cd(3);
                    hMeanErrors[current_order].Draw();
                    pulses.Update();
                }

                //-------------------------------------
                // Fill Distribution Histogramms
                //-------------------------------------

                hBsl[pulse_order].Fill(         edgeMedianPulse.GetBsl()    );
                hAsymptote[pulse_order].Fill(   edgeMedianPulse.GetHeight() );
                hT0[pulse_order].Fill(          edgeMedianPulse.GetT0()     );
                hTau1[pulse_order].Fill(        edgeMedianPulse.GetTau1()   );
                hTau2[pulse_order].Fill(        edgeMedianPulse.GetTau2()   );
                hIntegral[pulse_order].Fill(    edgeMedianPulse.GetIntegral());
                hAmplitude[pulse_order].Fill(   edgeMedianPulse.GetAmplitude());
                hRiseTime[pulse_order].Fill(    edgeMedianPulse.GetRiseTime());

                //-------------------------------------
                // Fill Distribution Graphs
                //-------------------------------------

                grPheVsAmpl.Set(grPheVsAmpl.GetN()+1);
                grPheVsIntegral.Set(grPheVsIntegral.GetN()+1);


                grPheVsAmpl.SetPoint(
                            grPheVsAmpl.GetN()-1,
                            edgeMedianPulse.GetPhE(),
                            edgeMedianPulse.GetAmplitude()
                            );

                grPheVsAmpl.SetPointError(
                            grPheVsAmpl.GetN()-1,
                            edgeMedianPulse.GetPhEErr(),
                            edgeMedianPulse.GetAmplitudeErr()
                            );

                grPheVsIntegral.SetPoint(
                            grPheVsIntegral.GetN()-1,
                            edgeMedianPulse.GetPhE(),
                            edgeMedianPulse.GetIntegral()
                            );

                grPheVsAmpl.SetPointError(
                            grPheVsIntegral.GetN()-1,
                            edgeMedianPulse.GetPhEErr(),
                            edgeMedianPulse.GetIntegralErr()
                            );

                grPheVsTau2.SetPoint(
                            grPheVsIntegral.GetN()-1,
                            edgeMedianPulse.GetPhE(),
                            edgeMedianPulse.GetTau2()
                            );

                grPheVsTau2.SetPointError(
                            grPheVsIntegral.GetN()-1,
                            edgeMedianPulse.GetPhE(),
                            edgeMedianPulse.GetTau2Err()
                            );

//                cgpDistributions[pulse_order].cd(1);


//                FitMaxPropabilityPuls(
//                            pixel[pixelID]->hPixelEdgeMean[pulse_order],
//                            verbosityLevel
//                            );

                //Preparing Camera
                if (first_pass)
                {
                    if (verbosityLevel > 0)
                    {
                        cout << endl << "...preparing camera" << endl;
                    }

                    wholeCamera = new PixelSum(
                                "AllPixel",
                                1440,
                                maxPulseOrder,
                                verbosityLevel,
                                stats,
                                "C",
                                pixel[pixelID]->mPixelOverlayXaxisLeft,
                                pixel[pixelID]->mPixelOverlayXaxisRight ,
                                pixel[pixelID]->mBSLMean ,
                                pixel[pixelID]->mGainMean ,
                                outputRootFile
                                );

                    first_pass = false;
                }

                //-------------------------------------
                // Fill Histogramms of Camera
                //-------------------------------------

                wholeCamera->hMaxOverlay[pulse_order]->Add(
                            pixel[pixelID]->hMaxOverlay[pulse_order]
                            );

                wholeCamera->hMaxProfile[pulse_order]->Add(
                            pixel[pixelID]->hMaxProfile[pulse_order]
                            );

                wholeCamera->hEdgeOverlay[pulse_order]->Add(
                            pixel[pixelID]->hEdgeOverlay[pulse_order]
                            );

                wholeCamera->hEdgeProfile[pulse_order]->Add(
                            pixel[pixelID]->hEdgeProfile[pulse_order]
                            );

                //-------------------------------------
                // Comparisons
                //-------------------------------------

                //chi2 test
//                float chi2 =
//                pixel[pixelID]->hPixelEdgeMean[pulse_order]->Chi2Test(
//                             pixel[pixelID]->hPixelMean[pulse_order],
//                            "UUPCHI2"
//                            );
//                cout << "p-Value :" << chi2 << endl;
//                wholeCamera->hChi2EdgetoMax[pulse_order]->Fill(chi2);
//                cgpDistributions[pulse_order]->cd();
//                wholeCamera->hChi2EdgetoMax[pulse_order]->Draw();

                if (verbosityLevel > 2)
                {
                cout << endl
                     << "...End of pulseorder "
                     << pulse_order
                     << endl;
                }

            }
            // End of Loop over pulsorder of current Pixel

            if (ProduceGraphic && debugPixel)
            {
                UpdateCanvases(
                            verbosityLevel,
                            MAX_PULS_ORDER,
                            false
                            );
            }

            if (debugPixel)
            {
                //Process gui events asynchronously during input
                cout << endl;
                TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
                timer.TurnOn();
                TString input = Getline("Type 'q' to exit, Type 's' to exit set, <return> to go on: ");
                timer.TurnOff();
                if (input=="q\n")
                {
                    return(0);
                }
                if (input=="s\n")
                {
                    break;
                }
            }

            if ( saveResults )
            {
                pixel[pixelID]->SavePixelHistograms(
                            outFile,
                            saveResults
                            );
            }

            //deleteCurrent Pixel from Heap
            delete  pixel[pixelID];
            pixel[pixelID]  = NULL;

            if (verbosityLevel > 2)
            {
            cout << endl
                 << "...End of Pixel"
                 << endl
                 << "------------------------------------------------"
                 << endl;
            }
        }
        // End of Loop over all Pixels of set

        if (verbosityLevel > 1)
        {
        cout << endl
             << "...End of Loop over all Pixels of set"
             << endl
             << "------------------------------------------------"
             << endl;
        }
    }
    // End of Loop over all Pixelsets

    if (verbosityLevel > 0)
    {
    cout << endl
         << "...End of Loop over all Pixelsets"
         << endl
         << "------------------------------------------------"
         << endl;
    }

    delete[] pixel;
    pixel = NULL;

//-------------------------------------
// Draw All Pixel Histograms
//-------------------------------------

    for ( int pulse_order = 0 ;
          pulse_order < wholeCamera->mMaxPulseOrder ;
          pulse_order ++)
    {
        if (verbosityLevel > 2)
        {
            cout << "-------------------------------------"
                 << endl
                 << "...processing Pulse-Order: "
                 << pulse_order;
        }

// Calculate Max Prop. Value of each slice
//-------------------------------------

        //from Maximum Overlay
        ExtractPulseTemplate(
                    wholeCamera,
                    "Maximum",
                    pulse_order,
                    bootstrapIt,
                    verbosityLevel
                    );
        if ( saveResults )
        {
            WritePixelTemplateToCsv(
                        wholeCamera,
                        OutPutPath,
                        "Maximum",
                        pulse_order,
                        verbosityLevel
                        );
        }

        //from Edge Overlay
        ExtractPulseTemplate(
                    wholeCamera,
                    "Edge",
                    pulse_order,
                    bootstrapIt,
                    verbosityLevel
                    );
        if ( saveResults )
        {
            WritePixelTemplateToCsv(
                        wholeCamera,
                        OutPutPath,
                        "Edge",
                        pulse_order,
                        verbosityLevel
                        );
        }

        if (ProduceGraphic)
        {
            wholeCamera->DrawTemplateHistograms(
                        cgpPixelPulses,
                        PixelCanvasFrameNrs
                        );

            wholeCamera->DrawEdgeTemplateHistograms(
                        cgpPixelPulses,
                        PixelCanvasFrameNrs
                        );
        }

        ShiftStartOfHistoInXTo(
                    wholeCamera->hEdgeOverlay[0],
                    0
                    );

        ShiftStartOfHistoInXTo(
                    wholeCamera->hMaxOverlay[0],
                    0
                    );

        // =======================================================
        //  Fit of pulse function to template

        Pulse* allPulseFits[6];

        pulses.cd(1);
        Pulse maxCamMaxPulse("maxMaxPulse", wholeCamera->hPixelMax[pulse_order], "Q", pulseModell);
        allPulseFits[0] = &maxCamMaxPulse;

        pulses.cd(2);
        Pulse maxCamMedianPulse("maxMedianPulse", wholeCamera->hPixelMedian[pulse_order], "Q", pulseModell);
        allPulseFits[1] = &maxCamMedianPulse;

        pulses.cd(3);
        Pulse maxCamMeanPulse("maxMeanPulse", wholeCamera->hPixelMean[pulse_order],"Q", pulseModell);
        allPulseFits[2] = &maxCamMeanPulse;

        Pulse edgeCamMaxPulse("edgeMaxPulse", wholeCamera->hPixelEdgeMax[pulse_order], "Q", pulseModell);
        allPulseFits[3] = &edgeCamMaxPulse;

        Pulse edgeCamMedianPulse("edgeMedianPulse", wholeCamera->hPixelEdgeMedian[pulse_order],"Q", pulseModell);
        allPulseFits[4] = &edgeCamMedianPulse;

        Pulse edgeCamMeanPulse("edgeMeanPulse", wholeCamera->hPixelEdgeMean[pulse_order], "Q", pulseModell);
        allPulseFits[5] = &edgeCamMeanPulse;


        //--------------------------------------------------------
        //Write parameters from pulse fit to CSV

        for (int i = 0; i < 6; i++)
        {
            PixelModelCsv.WritePulseAttributes(
                        wholeCamera,
                        allPulseFits[i],
                        "Edge",
                        pulse_order
                        );
        }
    } //EOF: Draw All Pixel Histograms


    //-------------------------------------
    // Draw Parameter Distributions
    //-------------------------------------

    if (ProduceGraphic)
    {
        cgpGraphs->cd(1);

        if (verbosityLevel > 0) cout << "...drawing grPheVsAmpl" << endl;
        grPheVsAmpl.Draw("AP");

        cgpGraphs->cd(2);
        if (verbosityLevel > 0) cout << "...drawing grPheVsIntegral" << endl;
        grPheVsIntegral.Draw("AP");

        cgpGraphs->cd(3);
        if (verbosityLevel > 0) cout << "...drawing grPheVsTau2" << endl;
        grPheVsTau2.Draw("AP");

        cgpGraphs->Update();

        for (int i = 0; i < maxPulseOrder; i++){
            cgpDistributions[i]->Divide(4,2);

            cgpDistributions[i]->cd(1);
            hBsl[i].Draw();
            cgpDistributions[i]->cd(2);
            hAsymptote[i].Draw();
            cgpDistributions[i]->cd(3);
            hT0[i].Draw();
            cgpDistributions[i]->cd(4);
            hTau1[i].Draw();
            cgpDistributions[i]->cd(5);
            hTau2[i].Draw();
            cgpDistributions[i]->cd(6);
            hIntegral[i].Draw();
            cgpDistributions[i]->cd(7);
            hAmplitude[i].Draw();
            cgpDistributions[i]->cd(8);
            hRiseTime[i].Draw();



        }





    }







//-------------------------------------
// Save All Pixel Histograms
//-------------------------------------
    if ( saveResults )
    {
        wholeCamera->SavePixelHistograms(
                    outFile,
                    saveResults
                    );

        SaveList(
                outFile,
                    "",
                histoList,
                saveResults,
                verbosityLevel
                );


    }

    if (ProduceGraphic)
    {
        UpdateCanvases(
                    verbosityLevel,
                    MAX_PULS_ORDER,
                    false
                    );

        //Process gui events asynchronously during input
        cout << endl;
        TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
        timer.TurnOn();
        TString input = Getline("press <return> to exit: ");
        timer.TurnOff();
        cout << input ;
    }

//-------------------------------------
// Delete Objects on Heap
//-------------------------------------
    delete wholeCamera;
    if (ProduceGraphic)
    {
        DeletePixelCanvases( maxPulseOrder ,verbosityLevel );
    }
    delete inputRootFile;
    delete outputRootFile;
    delete histoList;

    return( 0 );
}
//----------------------------------------------------------------------------
// end of main function
//-----------------------------------------------------------------------------




//-----------------------------------------------------------------------------
// Funktions
//-----------------------------------------------------------------------------
void
DeletePixelCanvases(
        int         maxPulseOrder,
        int         verbosityLevel
        )
{
    if (verbosityLevel > 2)
    {
        cout << endl
             << "...delete pixel Canvases"
             << endl;
    }

    for ( int pulse_order = 0; pulse_order < maxPulseOrder; pulse_order++ )
    {
        delete cgpPixelPulses[pulse_order];
        cgpPixelPulses[pulse_order]     = NULL;

        delete cgpDistributions[pulse_order];
        cgpDistributions[pulse_order]   = NULL;
    }

    delete[] cgpPixelPulses;
    cgpPixelPulses      = NULL;

    delete[] cgpDistributions;
    cgpDistributions    = NULL;
}

void
UpdateCanvases(
        int         verbosityLevel,
        int         max_pulse_order,
        bool        testmode
        )
{
    if (verbosityLevel > 3)
    {
        cout << endl << "...updating canvases" << endl;
    }
    for (int pulse_order = 0; pulse_order < max_pulse_order; pulse_order++)
    {
        cgpPixelPulses[pulse_order]->Modified();
        cgpPixelPulses[pulse_order]->Update();

        cgpDistributions[pulse_order]->Modified();
        cgpDistributions[pulse_order]->Update();
//        if ( testmode )
//        {
//            cgpTestHistos->Modified();
//            cgpTestHistos->Update();
//        }
    }
}
//-----------------------------------------------------------------------------
// MAIN Funktion for C compilation
//-----------------------------------------------------------------------------

int main(int argc,char *argv[])
{
//    Int_t   index;
    TString     test;
    TString     rcFileName;
    TString     processType             = "template";
    bool        rcFileNameCmdSet        = false;
    int         verbLevel               = 0; // different verbosity levels can be implemented here
    bool        verbLevelCmdSet         = false;
    bool        save                    = false;
    bool        produceGraphic          = false;

//    TString     inputRootFile       = "test.root";
//    TString     inputPath           = "";
//    TString     outputRootFile      = "test.root";
//    TString     outPutPath          = "";
//    int         firstPixel          = 0;
//    int         nPixel              = -1;
//    int         pixelSetSize        = 40;
//    int         maxOrder            = 3;
//    bool        dbgPixel            = false;
//    bool        fitdata             = false;
//    bool        printStats          = false;

    // decode arguments
    if(argc < 2)
    {
        printf("no arguements given, using standard arguments\n");
    }

    // set conditions for functions arguments
    for (int i=1;i<argc;i++)
    {
        test = argv[i];

        if (test.Contains("--config-file") || test.Contains("-c"))
        {
            cout << "RC-File: \"" << argv[i + 1] << "\"" << endl;
            rcFileName = argv[i + 1];
            rcFileNameCmdSet = true;
            continue;
        }

        if (test.Contains("--verbosity") || test.Contains("-v"))
        {
            cout << "Verbosity Level: \"" << argv[i + 1] << "\"" << endl;
            verbLevel = atoi(argv[i + 1]);
            continue;
        }

        if (test.Contains("--save") || test.Contains("-s"))
        {
            cout << "will save results" << endl;
            save = true;
            continue;
        }

        if (test.Contains("--graphics") || test.Contains("-g"))
        {
            cout << "will produce graphics" << endl;
            produceGraphic = true;
            continue;
        }
    }

    // reading rc-File:
    if (rcFileNameCmdSet)
    {
            configfile rcfile( rcFileName, processType );

        if (save)
        {
            rcfile.mSave = save;
        }

        if (verbLevelCmdSet)
        {
            rcfile.mVerbLevel = verbLevel;
        }

        if (produceGraphic)
        {
            rcfile.mProduceGraphic = produceGraphic;
        }

    //
        FCalcPulseTemplate(
                    rcfile.mInputFile,
                    rcfile.mInputPath,
                    rcfile.mOutputFile,
                    rcfile.mOutputPath,
                    rcfile.mFirstPixel,
                    rcfile.mNumPixel,
                    rcfile.mPixelSetSize,
                    rcfile.mMaxOrder,
//                    rcfile.mHistoOptions,
                    rcfile.mProduceGraphic,
                    rcfile.mPrintStats,
                    rcfile.mSave,
                    rcfile.mDbgPixel,
                    rcfile.mVerbLevel
                    );
    }
    else
    {
        cout << "user: check if configfile is set correctly in cmd" << endl;
    }

    return 0;
}


