
#include "Types.h"
#include "Utilities.h"

#include <ftdi.h>
#include <sys/ioctl.h>


#ifndef NULL
#ifdef __cplusplus
#define NULL 0
#else
#define NULL ((void *)0)
#endif
#endif 


#ifndef HV_H_SEEN
#define HV_H_SEEN


// Have a look at http://www.linux-usb.org/usb.ids
// Vendor: Future Technology Devices International, Ltd (FTDI)
#define USB_VENDOR  0X0403 
// Product: FT232 USB-Serial (UART) IC (USB <-> Serial converter, UM245R)
#define USB_PRODUCT 0X6001 


#define USB_BAUDRATE 115000
#define USB_LATENCY_TIMER 1


// HV board control registers
#define REG_VREF0   0X00
#define REG_VREF1   0X08
#define REG_VREF2   0X10
#define REG_VREF3   0X18

#define REG_HV0     0X20
#define REG_HV1     0X28
#define REG_HV2     0X30
#define REG_HV3     0X38

#define REG_RESET   0XF8
#define REG_STATUS  0X80

#define REG_PD1     0X04
#define REG_PD2     0X02


// HV board status bits
#define BIT_OC0    (1<<3)
#define BIT_OC1    (1<<4)
#define BIT_OC2    (1<<5)
#define BIT_OC3    (1<<6)

#define BIT_RESET  (1<<7)


class HVBoard {
  
 public:
  
  HVBoard(char* serial, int number, struct ftdi_context* ftdic);
  ~HVBoard();

  int Init(bool verbose);
  int Reset(FILE* fptr, unsigned char* rbuf, bool verbose);
  int GetStatus(FILE* fptr, unsigned char* rbuf, bool verbose);
  int SetVRef(FILE* fptr, int chain, unsigned int vref, unsigned char* rbuf, bool verbose);
  int SetHV(FILE* fptr, int chain, unsigned int channel, unsigned int hv, unsigned char* rbuf, bool verbose);
  struct ftdi_context* GetFTDI_C() {return FTDI_C;}
  char* GetSerial() {return Serial;}
  int GetBoardNumber() {return BoardNumber;}
  int Write(unsigned char* data, int size);
  int Read(unsigned char* data, int size);
  int TRead(FILE* fptr, unsigned char* rbuf, bool verbose);
  void SetTimeOut(float t) {fTimeOut = t;}
  float GetTimeOut() {return fTimeOut;}
  void TestIO();       // Warning: NEVER use this function with a real HV board!!!
  int DecodeWrap(unsigned char* rbuf);
  void DecodeOC(bool OC[], unsigned char* rbuf);
  bool DecodeReset(unsigned char* rbuf);

  struct ftdi_context* FTDI_C;
  char Serial[STR_LENGTH];
  int  BoardNumber;
  float fTimeOut;      // [s] timeout to return from read 
  
};



class HV {

 public:
  
  HV(char** usbdevice, int* usbdevicenumber, FILE* f);
  ~HV();

  int fNumberOfBoards;
  int fMaxNumberOfBoards;

  HVBoard* fHVBoard[MAX_NUM_HVBOARDS];
  int GetNumberOfBoards() {return fNumberOfBoards;} 
  void SetNumberOfBoards(int i) {fNumberOfBoards = i;}
  HVBoard* GetHVBoard(int i) {return fHVBoard[i];}
  
 protected:

  // For FTDI USB <-> serial converter 
  struct ftdi_context ftdic[MAX_NUM_HVBOARDS];
  struct ftdi_context ftdic_dummy;
  struct ftdi_device_list *devlist, *curdev;
  
  void ArrangeHVBoards(HVBoard** fHVBoard, int size);
 
};

#endif
