
/********************************************************************\

  Name:         HVMonitor.cc

  Created by:   Sebastian Commichau, November 2008
                commichau@phys.ethz.ch

  Actions:      Monitor HV board status

\********************************************************************/

#include "HVMonitor.h"


void HVMonitor(ProcessIO *m) {
  
  siginterrupt(SIGUSR1, true);
 
  while (!m->status->Exit) {

    if (!m->status->Stop)
      m->Monitor();

    usleep((unsigned long)floor(1000000./(m->hv->GetNumberOfBoards()*m->status->fStatusRefreshRate)));
  }

}
