
#include "Log.h"

Log::Log(char logpath[]) {

  char logfile[FILENAME_MAX_SIZE];
  time_t time_now_secs;
  struct tm *time_now;

  time(&time_now_secs);
  time_now = localtime(&time_now_secs);

  // Open log file
  sprintf(logfile, "%s/hvutil_%04d_%02d_%02d_%02d_%02d_%02d.log", 
	  logpath,
	  1900 + time_now->tm_year,
	  1 + time_now->tm_mon,
	  time_now->tm_mday,
	  time_now->tm_hour,
	  time_now->tm_min,
	  time_now->tm_sec);
  if ((logptr = fopen(logfile, "w")) == NULL) {
    fprintf(stderr,"Log::Log: could not open file %s => check DAQ config file\n", logfile);
    exit(1);
  }  

  LogWrite("start logfile\n");
}


Log::~Log() {
  LogWrite("end logfile\n");
  fclose(logptr);
  printf("Logfile closed\n");
}


int Log::LogWrite(char logtext[]) {
  time_t time_now_secs;
  struct tm *time_now;

  time(&time_now_secs);
  time_now = localtime(&time_now_secs);

  fprintf(logptr, "[%04d:%02d:%02d:%02d:%02d:%02d] %s",
	  1900 + time_now->tm_year,
	  1 + time_now->tm_mon,
	  time_now->tm_mday,
	  time_now->tm_hour,
	  time_now->tm_min,
	  time_now->tm_sec,
	  logtext);
  fflush(logptr);

  return 0;
}
